/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedNSEWDMTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btSymbol = new byte[26];
    private int m_nSettlementDays = 0;
    private byte[] m_btTradeType = new byte[3];
    private int m_nRepoTerm = 0;
    private int m_nOpen = 0;
    private int m_nHigh = 0;
    private int m_nLow = 0;
    private int m_nClose = 0;
    private int m_nLastTradedPrice = 0;
    private int m_nTotalTradedValue = 0;
    private int m_nPreviousClosePrice = 0;
    private byte[] m_btSecurityStatus = new byte[1];
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 4;

    public short Update(CMsgHeader f_objMsgHeader, DataInputStream f_objDataOutputStream) {
        try {
            this.m_nFTCode = f_objDataOutputStream.readInt();
            f_objDataOutputStream.read(this.m_btSymbol, 0, 26);
            this.m_nSettlementDays = f_objDataOutputStream.readInt();
            f_objDataOutputStream.read(this.m_btTradeType, 0, 3);
            this.m_nRepoTerm = f_objDataOutputStream.readInt();
            this.m_nOpen = f_objDataOutputStream.readInt();
            this.m_nHigh = f_objDataOutputStream.readInt();
            this.m_nLow = f_objDataOutputStream.readInt();
            this.m_nClose = f_objDataOutputStream.readInt();
            this.m_nLastTradedPrice = f_objDataOutputStream.readInt();
            this.m_nTotalTradedValue = f_objDataOutputStream.readInt();
            this.m_nPreviousClosePrice = f_objDataOutputStream.readInt();
            f_objDataOutputStream.read(this.m_btSecurityStatus, 0, 1);
            this.m_strKeyOfData = this.CreateKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public short UpdateLLF(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 25);
            }
            this.m_nSettlementDays = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[7], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btTradeType, 0, 2);
            }
            this.m_nRepoTerm = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[12], f_objMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalTradedValue = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[15], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[16], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[17] != 0) {
                f_objDataInputStream.read(this.m_btSecurityStatus, 0, 1);
            }
            this.m_strKeyOfData = this.CreateKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private StringBuffer CreateKey(int f_nFTCode, String f_strSymbol) {
        StringBuffer strTemp = new StringBuffer();
        f_strSymbol = f_strSymbol.replace('^', '#');
        return strTemp.append(f_nFTCode).append(":").append(f_strSymbol).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, 0, 0, 0, 0, this.m_nClose, this.m_nPreviousClosePrice, f_objMsgHeader.m_nMsgTimeStamp, 0, this.m_nOpen, this.m_nHigh, this.m_nLow);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClose, 0, this.m_nOpen, this.m_nHigh, this.m_nLow, this.m_nPreviousClosePrice, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, 0, this.m_nTotalTradedValue);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nClose, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClose, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

