/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;
import structures.InfoFeedBestBuySell;

public class InfoFeedNCDEXFAOSPOTTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btInstrument = new byte[7];
    private byte[] m_btSymbol = new byte[11];
    private int m_nExpiryDate = 0;
    private int m_nStrikePrice = 0;
    private byte[] m_btOptionType = new byte[3];
    private byte[] m_btMarketType = new byte[1];
    private InfoFeedBestBuySell m_objInfoFeedBestBuySell = new InfoFeedBestBuySell();
    private int m_nLastTradedRate = 0;
    private int m_nTotalTradedQty = 0;
    private byte[] m_btCommodityStatus = new byte[1];
    private int m_nOpenRate = 0;
    private int m_nHighRate = 0;
    private int m_nLowRate = 0;
    private int m_nCloseRate = 0;
    private int m_nPreviousClosePrice = 0;
    private int m_nOpenInterest = 0;
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 2;

    public short UpdateLLFFAOTouchline(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btInstrument, 0, 6);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 10);
            }
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[8], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[10] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            if (f_objMsgHeader.m_nFieldDescription[11] != 0) {
                f_objDataInputStream.read(this.m_btMarketType, 0, 1);
            }
            if (-1 == this.m_objInfoFeedBestBuySell.UpdateRate(f_objDataInputStream, f_objMsgHeader, 0, 12)) {
                return -1;
            }
            this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[16], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalTradedQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[17], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[18] != 0) {
                f_objDataInputStream.read(this.m_btCommodityStatus, 0, 1);
            }
            this.m_nOpenRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[19], f_objMsgHeader.m_nBaseValue);
            this.m_nHighRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[20], f_objMsgHeader.m_nBaseValue);
            this.m_nLowRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[21], f_objMsgHeader.m_nBaseValue);
            this.m_nCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[22], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[23], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btInstrument), this.m_nExpiryDate, this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), Utilities.RemoveNull(this.m_btSymbol)).toString();
            this.setFAOData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFSPOTTouchline(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btInstrument, 0, 6);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 10);
            }
            if (f_objMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btMarketType, 0, 1);
            }
            this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            this.m_nCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            int m_nSpotPriceUpdateTimeStamp = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[12], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btSymbol)).toString();
            this.setSPOTData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFOpenInterest(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btInstrument, 0, 6);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 10);
            }
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[8], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[10] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[12] != 0) {
                f_objDataInputStream.read(this.m_btMarketType, 0, 1);
            }
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btInstrument), this.m_nExpiryDate, this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), Utilities.RemoveNull(this.m_btSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode, String strInstrumentName, int iExpiryDate, int iStrikePrice, String strOptionType, String strSymbol) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":").append(strInstrumentName).append(":").append(iExpiryDate).append(":").append(iStrikePrice).append(":").append(strOptionType).append(":N:").append(strSymbol).append(":");
    }

    private StringBuffer createKey(int iFTCode, String strSymbol) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":").append(strSymbol).append(":");
    }

    private void setFAOData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_objInfoFeedBestBuySell.m_nBuyQty, this.m_objInfoFeedBestBuySell.m_nBuyRate, this.m_objInfoFeedBestBuySell.m_nSellQty, this.m_objInfoFeedBestBuySell.m_nSellRate, this.m_nCloseRate, this.m_nPreviousClosePrice, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate);
                break;
            }
            case 24: {
                this.m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                strData[0] = Utilities.ToString(this.m_objInfoFeedBestBuySell.m_nBuyQty);
                strData[1] = Utilities.ConvertToDecimal(this.m_objInfoFeedBestBuySell.m_nBuyRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                strData[2] = Utilities.ToString(this.m_objInfoFeedBestBuySell.m_nSellQty);
                strData[3] = Utilities.ConvertToDecimal(this.m_objInfoFeedBestBuySell.m_nSellRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nCloseRate, this.m_nTotalTradedQty, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate, this.m_nPreviousClosePrice, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, 0, 0L);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nCloseRate, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nCloseRate, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }

    private void setSPOTData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, 0, 0, 0, 0, this.m_nCloseRate, this.m_nPreviousClosePrice, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, 0, 0, 0);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nCloseRate, 0, 0, 0, 0, this.m_nPreviousClosePrice, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, 0, 0L);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nCloseRate, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 24: {
                iWinRefresh.getInstance().showform.bestfive.setOpenInt(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nOpenInterest);
            }
        }
    }
}

