/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;
import structures.InfoFeedBestBuySell;

public class InfoFeedLMETouchline {
    private int m_nFTCode = 0;
    private byte[] m_btSymbol = new byte[21];
    private byte[] m_btExchangeSymbol = new byte[21];
    private byte[] m_btOptionType = new byte[3];
    private short m_nPriceMultiplier = 0;
    private short m_nStrikePriceMultiplier = 0;
    private int m_nContractExpiry = 0;
    private int m_nStrikePrice = 0;
    private int m_nPercentNetChange = 0;
    private int m_nNetChange = 0;
    private int m_nLastTradedRate = 0;
    private int m_nLastTradedVolume = 0;
    private int m_nLastTradedTime = 0;
    private int m_nTotalVolumeTraded = 0;
    private int m_nOpenInterest = 0;
    private byte[] m_btTickIndicator = new byte[1];
    private int m_nPreviousCloseRate = 0;
    private int m_nOpen = 0;
    private int m_nHigh = 0;
    private int m_nLow = 0;
    private int m_nClose = 0;
    private short m_nSessionIndicator = (short)-1;
    private InfoFeedBestBuySell[] m_objBestBuySell;
    private String m_strKeyOfData;

    public InfoFeedLMETouchline(int iNoOfBestBuySell) {
        this.m_objBestBuySell = new InfoFeedBestBuySell[iNoOfBestBuySell];
        this.m_strKeyOfData = "";
    }

    public short Update(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSymbol, 0, 21);
            f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 21);
            f_objDataInputStream.read(this.m_btOptionType, 0, 3);
            this.m_nPriceMultiplier = f_objDataInputStream.readShort();
            this.m_nStrikePriceMultiplier = f_objDataInputStream.readShort();
            this.m_nContractExpiry = f_objDataInputStream.readInt();
            this.m_nStrikePrice = f_objDataInputStream.readInt();
            this.m_nPercentNetChange = f_objDataInputStream.readInt();
            this.m_nNetChange = f_objDataInputStream.readInt();
            this.m_nLastTradedRate = f_objDataInputStream.readInt();
            this.m_nLastTradedVolume = f_objDataInputStream.readInt();
            this.m_nLastTradedTime = f_objDataInputStream.readInt();
            this.m_nTotalVolumeTraded = f_objDataInputStream.readInt();
            this.m_nOpenInterest = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btTickIndicator, 0, 1);
            this.m_nPreviousCloseRate = f_objDataInputStream.readInt();
            this.m_nOpen = f_objDataInputStream.readInt();
            this.m_nHigh = f_objDataInputStream.readInt();
            this.m_nLow = f_objDataInputStream.readInt();
            this.m_nClose = f_objDataInputStream.readInt();
            this.m_nSessionIndicator = f_objDataInputStream.readShort();
            int iNoOfBuySell = this.m_objBestBuySell.length;
            for (int l_nBestBuySellIndex = 0; l_nBestBuySellIndex < iNoOfBuySell; ++l_nBestBuySellIndex) {
                this.m_objBestBuySell[l_nBestBuySellIndex] = new InfoFeedBestBuySell();
                if (-1 != this.m_objBestBuySell[l_nBestBuySellIndex].UpdateQty(f_objDataInputStream)) continue;
                return -1;
            }
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLF(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nContractExpiry = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[12], f_objMsgHeader.m_nBaseValue);
            this.m_nPercentNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.m_nNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[15], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[16], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedTime = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[17], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalVolumeTraded = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[18], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[19], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[20] != 0) {
                f_objDataInputStream.read(this.m_btTickIndicator, 0, 1);
            }
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[21], f_objMsgHeader.m_nBaseValue);
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[22], f_objMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[23], f_objMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[24], f_objMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[25], f_objMsgHeader.m_nBaseValue);
            this.m_nSessionIndicator = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[26], f_objMsgHeader.m_nBaseValue);
            int iNoOfBuySell = this.m_objBestBuySell.length;
            for (int l_nBestBuySellIndex = 0; l_nBestBuySellIndex < iNoOfBuySell; ++l_nBestBuySellIndex) {
                this.m_objBestBuySell[l_nBestBuySellIndex] = new InfoFeedBestBuySell();
                if (-1 != this.m_objBestBuySell[l_nBestBuySellIndex].UpdateQty(f_objDataInputStream, f_objMsgHeader, l_nBestBuySellIndex, 24)) continue;
                return -1;
            }
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLIFFELLF(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nContractExpiry = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[12], f_objMsgHeader.m_nBaseValue);
            this.m_nPercentNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.m_nNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[15], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedTime = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[16], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalVolumeTraded = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[17], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[18], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[19], f_objMsgHeader.m_nBaseValue);
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[20], f_objMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[21], f_objMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[22], f_objMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[23], f_objMsgHeader.m_nBaseValue);
            int iNoOfBuySell = this.m_objBestBuySell.length;
            for (int l_nBestBuySellIndex = 0; l_nBestBuySellIndex < iNoOfBuySell; ++l_nBestBuySellIndex) {
                this.m_objBestBuySell[l_nBestBuySellIndex] = new InfoFeedBestBuySell();
                if (-1 != this.m_objBestBuySell[l_nBestBuySellIndex].UpdateQty(f_objDataInputStream, f_objMsgHeader, l_nBestBuySellIndex, 24)) continue;
                return -1;
            }
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode, String strExchangeSymbol) {
        StringBuffer strTemp = new StringBuffer();
        strExchangeSymbol = strExchangeSymbol.replace(':', '#');
        strExchangeSymbol = strExchangeSymbol.replace('\\', '*');
        return strTemp.append(iFTCode).append(":").append(strExchangeSymbol).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_objBestBuySell[0].m_nBuyQty, this.m_objBestBuySell[0].m_nBuyRate, this.m_objBestBuySell[0].m_nSellQty, this.m_objBestBuySell[0].m_nSellRate, this.m_nClose, this.m_nPreviousCloseRate, f_objMsgHeader.m_nMsgTimeStamp, this.m_nPriceMultiplier, this.m_nOpen, this.m_nHigh, this.m_nLow);
                break;
            }
            case 24: {
                this.m_nPriceMultiplier = (short)iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                for (int i = 0; i < this.m_objBestBuySell.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_objBestBuySell[i].m_nBuyQty);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_objBestBuySell[i].m_nBuyRate, (int)this.m_nPriceMultiplier, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_objBestBuySell[i].m_nSellQty);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_objBestBuySell[i].m_nSellRate, (int)this.m_nPriceMultiplier, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClose, this.m_nTotalVolumeTraded, this.m_nOpen, this.m_nHigh, this.m_nLow, this.m_nPreviousCloseRate, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nPriceMultiplier, 0, 0L);
                iWinRefresh.getInstance().showform.bestfive.setOpenInt(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nOpenInterest);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClose, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

