/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class CInfofeedMCXSXEQIndices {
    private int m_nFTCode = 0;
    private int m_nUniqueIdentifier = 0;
    private short m_nIndicativeFlag = 0;
    private byte[] m_btIndexName = new byte[13];
    private long m_lDecimalLocator = 2L;
    private int m_nLTP = 0;
    private int m_nOpenPrice = 0;
    private int m_nHighPrice = 0;
    private int m_nLowPrice = 0;
    private int m_nClosePrice = 0;
    private int m_nPCP = 0;
    private byte[] m_btInstrumentName = new byte[11];
    private String m_strKeyOfData = "";

    public short Update(CMsgHeader f_ObjMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            if (-1 == this.updateMultipleIndex(f_ObjMsgHeader, f_objDataInputStream)) {
                return -1;
            }
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private short updateMultipleIndex(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int j = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nUniqueIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 1], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nIndicativeFlag = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 2], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 3] != 0) {
                f_objDataInputStream.read(this.m_btIndexName, 0, 12);
            }
            this.m_lDecimalLocator = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 4], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lDecimalLocator = this.GetPriceMultiplier(this.m_lDecimalLocator);
            this.m_nOpenPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 5], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 6], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 7], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 8], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPCP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 9], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 10] != 0) {
                f_objDataInputStream.read(this.m_btInstrumentName, 0, 10);
            }
            this.m_strKeyOfData = this.createKey(this.m_nFTCode).toString();
            this.updateMarketWatchIndex(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int ipFTCode) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(ipFTCode).append(":0");
    }

    private void updateMarketWatchIndex(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetIndex(this.m_strKeyOfData, this.m_nClosePrice, this.m_nPCP, (int)this.m_lDecimalLocator, f_objMsgHeader.m_nSegmentId, f_objMsgHeader.m_nMsgTimeStamp, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClosePrice, 0, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice, this.m_nPCP, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, (int)this.m_lDecimalLocator, 0, 0L);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nLTP, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }

    private int GetPriceMultiplier(long f_nPriceMultiplier) {
        if (f_nPriceMultiplier < 10L) {
            return (int)f_nPriceMultiplier;
        }
        int lnCount = 0;
        do {
            ++lnCount;
        } while ((f_nPriceMultiplier /= 10L) != 1L);
        return lnCount;
    }
}

