/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class CInfofeedMCXSXDervTouchline {
    int m_nFTCode = 0;
    int m_nUniqueIdentifier = 0;
    int m_nUnderlyingUniqueIdentifier = 0;
    byte[] m_btSymbol = new byte[13];
    byte[] m_btSeries = new byte[3];
    short m_nReserved1 = 0;
    int m_nExpiryDate = 0;
    int m_nStrikePrice = 0;
    byte[] m_btOptionType = new byte[3];
    long m_lDecimalLocator = 0L;
    int[] m_nBuyQty;
    int[] m_nBuyPrice;
    int[] m_nSellQty;
    int[] m_nSellPrice;
    int m_nLTP;
    int m_nLTQ;
    byte[] m_btLTT;
    int m_nATP;
    int m_nTTQ;
    int m_nOI;
    int m_nOpenPrice;
    int m_nHighPrice;
    int m_nLowPrice;
    int m_nClosePrice;
    long m_lValue;
    byte[] m_btPQU;
    long m_lQL;
    int m_nPCP;
    long m_lTBQ;
    long m_lTSQ;
    int m_nNumberOfTrades;
    int m_nIsSpreadToken;
    byte[] m_btInstrumentName;
    byte[] m_btReserved2;
    byte[] m_btProductMonth;
    private String m_strKeyOfData;

    public CInfofeedMCXSXDervTouchline(int iNoOfBestBuySell) {
        this.m_nBuyQty = new int[iNoOfBestBuySell];
        this.m_nBuyPrice = new int[iNoOfBestBuySell];
        this.m_nSellQty = new int[iNoOfBestBuySell];
        this.m_nSellPrice = new int[iNoOfBestBuySell];
        this.m_nLTP = 0;
        this.m_nLTQ = 0;
        this.m_btLTT = new byte[31];
        this.m_nATP = 0;
        this.m_nTTQ = 0;
        this.m_nOI = 0;
        this.m_nOpenPrice = 0;
        this.m_nHighPrice = 0;
        this.m_nLowPrice = 0;
        this.m_nClosePrice = 0;
        this.m_lValue = 0L;
        this.m_btPQU = new byte[21];
        this.m_lQL = 0L;
        this.m_nPCP = 0;
        this.m_lTBQ = 0L;
        this.m_lTSQ = 0L;
        this.m_nNumberOfTrades = 0;
        this.m_nIsSpreadToken = 0;
        this.m_btInstrumentName = new byte[11];
        this.m_btReserved2 = new byte[3];
        this.m_btProductMonth = new byte[11];
        this.m_strKeyOfData = "";
    }

    public short UpdateLLFTouchline(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int j = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nUniqueIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 1], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nUnderlyingUniqueIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 2], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 3] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 12);
            }
            this.m_nReserved1 = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 4], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 5], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 6], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 7] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_lDecimalLocator = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 8], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lDecimalLocator = this.GetPriceMultiplier(this.m_lDecimalLocator);
            for (int i = 0; i < 1; ++i) {
                this.m_nBuyQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 9], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBuyPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 10], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 11], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 12], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_nLTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 13], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 14] != 0) {
                f_objDataInputStream.read(this.m_btLTT, 0, 30);
            }
            this.m_nATP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 15], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 16], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOI = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 17], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 18], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 19], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 20], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 21], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lValue = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 22], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 23] != 0) {
                f_objDataInputStream.read(this.m_btPQU, 0, 20);
            }
            this.m_lQL = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 24], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPCP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 25], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nIsSpreadToken = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 26], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 27] != 0) {
                f_objDataInputStream.read(this.m_btInstrumentName, 0, 10);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 28] != 0) {
                f_objDataInputStream.read(this.m_btReserved2, 0, 2);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 29] != 0) {
                f_objDataInputStream.read(this.m_btProductMonth, 0, 10);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nUnderlyingUniqueIdentifier, Utilities.RemoveNull(this.m_btOptionType).toString(), this.m_nExpiryDate, this.m_nStrikePrice, f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFBestFive(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            int j = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nUniqueIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 1], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nUnderlyingUniqueIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 2], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 3] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 12);
            }
            this.m_nReserved1 = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 4], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 5], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 6], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 7] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_lDecimalLocator = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 8], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lDecimalLocator = this.GetPriceMultiplier(this.m_lDecimalLocator);
            for (i = 0; i < 5; ++i) {
                this.m_nBuyQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 9], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBuyPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 10], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            for (i = 0; i < 5; ++i) {
                this.m_nSellQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 19], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 20], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_nLTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 29], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 30] != 0) {
                f_objDataInputStream.read(this.m_btLTT, 0, 30);
            }
            this.m_nATP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 31], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 32], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOI = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 33], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 34], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 35], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 36], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 37], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lValue = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 38], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 39] != 0) {
                f_objDataInputStream.read(this.m_btPQU, 0, 20);
            }
            this.m_lQL = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 40], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPCP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 41], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lTBQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 42], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lTSQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 43], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nNumberOfTrades = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 44], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nIsSpreadToken = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 45], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 46] != 0) {
                f_objDataInputStream.read(this.m_btInstrumentName, 0, 10);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 47] != 0) {
                f_objDataInputStream.read(this.m_btReserved2, 0, 2);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 48] != 0) {
                f_objDataInputStream.read(this.m_btProductMonth, 0, 10);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nUnderlyingUniqueIdentifier, Utilities.RemoveNull(this.m_btOptionType).toString(), this.m_nExpiryDate, this.m_nStrikePrice, f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createkey(int iFTCode, int nUndlayingUniqueIdentifier, String sOptionType, int f_nExpiryDate, int f_nStrikePrice, int f_nSegmentId) {
        StringBuffer strTemp = new StringBuffer();
        if (f_nSegmentId == 34) {
            return strTemp.append(iFTCode).append(":").append(nUndlayingUniqueIdentifier).append(":").append(sOptionType).append(":").append(f_nExpiryDate).append(":").append(f_nStrikePrice).append(":");
        }
        return strTemp;
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nBuyQty[0], this.m_nBuyPrice[0], this.m_nSellQty[0], this.m_nSellPrice[0], this.m_nClosePrice, this.m_nPCP, f_objMsgHeader.m_nMsgTimeStamp, (int)this.m_lDecimalLocator, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                for (int i = 0; i < this.m_nBuyPrice.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_nBuyQty[i]);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_nBuyPrice[i], (int)this.m_lDecimalLocator, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_nSellQty[i]);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_nSellPrice[i], (int)this.m_lDecimalLocator, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClosePrice, this.m_nTTQ, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice, this.m_nPCP, (int)this.m_lTBQ, (int)this.m_lTSQ, f_objMsgHeader.m_nMsgTimeStamp, (int)this.m_lDecimalLocator, this.m_nATP, this.m_lValue);
                iWinRefresh.getInstance().showform.bestfive.setOpenInt(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nOI);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nClosePrice, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClosePrice, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }

    private int GetPriceMultiplier(long f_nPriceMultiplier) {
        if (f_nPriceMultiplier < 10L) {
            return (int)f_nPriceMultiplier;
        }
        int lnCount = 0;
        do {
            ++lnCount;
        } while ((f_nPriceMultiplier /= 10L) != 1L);
        return lnCount;
    }
}

