/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class CInfofeedACEFAOTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btUniqueIdentifier = new byte[31];
    private byte[] m_btSymbol = new byte[31];
    private int m_nExpiryDate = 0;
    private int m_nStrikePrice = 0;
    private byte[] m_btOptionType = new byte[3];
    private short m_nPriceMultiplier = 0;
    private short m_nStrikePriceMultiplier = 0;
    private int[] m_nBidQty;
    private int[] m_nBidPrice;
    private int[] m_nBidNoOfOrder;
    private int[] m_nAskQty;
    private int[] m_nAskPrice;
    private int[] m_nAskNoOfOrder;
    private int m_nLTP = 0;
    private int m_nLTQ = 0;
    private byte[] m_btLTT = new byte[31];
    private int m_nVWAP = 0;
    private int m_nTTQ = 0;
    private int m_nOI = 0;
    private int m_nOpenPrice = 0;
    private int m_nHighPrice = 0;
    private int m_nLowPrice = 0;
    private int m_nClosePrice = 0;
    private long m_nValue = 0L;
    private int m_nHighestBidPrice = 0;
    private int m_nLowestAskPrice = 0;
    private int m_nHighLimitPrice = 0;
    private int m_nLowLimitPrice = 0;
    private int m_nPCP = 0;
    private int m_nSettlelementPrice = 0;
    private int m_nSettlelementDate = 0;
    private long m_nTotalBidQuantity = 0L;
    private long m_nTotalAskQuantity = 0L;
    private int m_nNoOfTrades = 0;
    private String m_strKeyOfData = "";
    private String m_AlertstrKeyOfData;
    private int m_nDivisionFactor = 2;

    public CInfofeedACEFAOTouchline(int iNoOfBestBuySell) {
        this.m_nBidQty = new int[iNoOfBestBuySell];
        this.m_nBidPrice = new int[iNoOfBestBuySell];
        this.m_nBidNoOfOrder = new int[iNoOfBestBuySell];
        this.m_nAskQty = new int[iNoOfBestBuySell];
        this.m_nAskPrice = new int[iNoOfBestBuySell];
        this.m_nAskNoOfOrder = new int[iNoOfBestBuySell];
    }

    public short UpdateLLFTouchline(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            int j = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 1] != 0) {
                f_objDataInputStream.read(this.m_btUniqueIdentifier, 0, 30);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 2] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 30);
            }
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 3], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 4], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 5] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 6], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 7], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLTP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 8], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 9], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 10] != 0) {
                f_objDataInputStream.read(this.m_btLTT, 0, 30);
            }
            this.m_nVWAP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 11], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 12], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOI = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 13], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 14], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 15], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 16], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 17], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nValue = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 18], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighestBidPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 19], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowestAskPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 20], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighLimitPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 21], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowLimitPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 22], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPCP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 23], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nSettlelementPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 24], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nSettlelementDate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 25], f_objInfoFeedMsgHeader.m_nBaseValue);
            for (i = 0; i < 1; ++i) {
                this.m_nBidQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 26], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBidPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 27], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBidNoOfOrder[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 28], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            for (i = 0; i < 1; ++i) {
                this.m_nAskQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 29], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nAskPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 30], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nAskNoOfOrder[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 31], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, Utilities.RemoveNull(this.m_btUniqueIdentifier).toString(), Utilities.RemoveNull(this.m_btSymbol).toString(), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.m_AlertstrKeyOfData = this.createkey(this.m_nFTCode, Utilities.RemoveNull(this.m_btUniqueIdentifier).toString(), Utilities.RemoveNull(this.m_btSymbol).toString(), this.m_nExpiryDate, "FUTURE", this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType).toString(), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFBestFive(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            int j = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 1] != 0) {
                f_objDataInputStream.read(this.m_btUniqueIdentifier, 0, 30);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 2] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 30);
            }
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 3], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 4], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 5] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 6], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 7], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLTP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 8], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 9], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 10] != 0) {
                f_objDataInputStream.read(this.m_btLTT, 0, 30);
            }
            this.m_nVWAP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 11], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 12], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOI = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 13], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 14], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 15], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 16], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 17], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nValue = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 18], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighestBidPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 19], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowestAskPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 20], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighLimitPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 21], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowLimitPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 22], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPCP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 23], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nSettlelementPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 24], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nSettlelementDate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 25], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalBidQuantity = Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 26], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalAskQuantity = Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 27], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nNoOfTrades = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 28], f_objInfoFeedMsgHeader.m_nBaseValue);
            for (i = 0; i < 5; ++i) {
                this.m_nBidQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[3 * i + j + 29], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBidPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[3 * i + j + 30], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBidNoOfOrder[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[3 * i + j + 31], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            for (i = 0; i < 5; ++i) {
                this.m_nAskQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[3 * i + j + 44], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nAskPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[3 * i + j + 45], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nAskNoOfOrder[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[3 * i + j + 46], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, Utilities.RemoveNull(this.m_btUniqueIdentifier).toString(), Utilities.RemoveNull(this.m_btSymbol).toString(), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.m_AlertstrKeyOfData = this.createkey(this.m_nFTCode, Utilities.RemoveNull(this.m_btUniqueIdentifier).toString(), Utilities.RemoveNull(this.m_btSymbol).toString(), this.m_nExpiryDate, "FUTURE", this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType).toString(), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createkey(int iFTCode, String iUniqueIdentifier, String iSymbol, int f_nSegmentId) {
        StringBuffer strTemp = new StringBuffer();
        if (iUniqueIdentifier.indexOf(95) > 0) {
            iUniqueIdentifier = iUniqueIdentifier.replace('_', '+');
        }
        if (f_nSegmentId == 60) {
            return strTemp.append(iFTCode).append(":").append(iUniqueIdentifier).append(":").append(iSymbol).append(":");
        }
        return strTemp;
    }

    private StringBuffer createkey(int iFTCode, String iUniqueIdentifier, String iSymbol, int expirydt, String fao, int strikeprice, String optiontype, int f_nSegmentId) {
        StringBuffer strTemp = new StringBuffer();
        if (iUniqueIdentifier.indexOf(95) > 0) {
            iUniqueIdentifier = iUniqueIdentifier.replace('_', '+');
        }
        if (f_nSegmentId == 60) {
            return strTemp.append(iFTCode).append(":").append(iUniqueIdentifier).append(":").append(iSymbol).append(":").append(expirydt).append(":").append("FUTURE").append(":").append(strikeprice).append(":").append(optiontype).append(":");
        }
        return strTemp;
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nBidQty[0], this.m_nBidPrice[0], this.m_nAskQty[0], this.m_nAskPrice[0], this.m_nClosePrice, this.m_nPCP, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice);
                break;
            }
            case 24: {
                this.m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                for (int i = 0; i < this.m_nBidPrice.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_nBidQty[i]);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_nBidPrice[i], this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_nAskQty[i]);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_nAskPrice[i], this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClosePrice, this.m_nTTQ, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice, this.m_nPCP, (int)this.m_nTotalBidQuantity, (int)this.m_nTotalAskQuantity, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nVWAP, 0L);
                iWinRefresh.getInstance().showform.bestfive.setOpenInt(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nOI);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nClosePrice, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_AlertstrKeyOfData, this.m_nClosePrice, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

