/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import market.iWinRefresh;

public class ViewDetails
implements JCommandListener {
    private String[] strValueData;
    private String[] strHeadingData;
    private int iCurrentPageNo;
    private int iMaxPageNo;
    private final int BUYQTY_INDEX;
    private final int BUYPRICE_INDEX;
    private final int SELLQTY_INDEX;
    private final int SELLPRICE_INDEX;
    private final int LTP_INDEX;
    private final int SEGMENTID_INDEX;
    private final int INSTRUMENTID_INDEX;
    private final int KEYOFDATA_INDEX;
    private final int HEADING_INDEX;
    private final int DIVISION_INDEX;
    private String[] strData = new String[4];
    private JPlatformCanvas canvas = JPlatformCanvas.getInstance();
    private int iDivision;

    public ViewDetails() {
        this.BUYQTY_INDEX = 0;
        this.BUYPRICE_INDEX = 1;
        this.SELLQTY_INDEX = 2;
        this.SELLPRICE_INDEX = 3;
        this.LTP_INDEX = 4;
        this.SEGMENTID_INDEX = 0;
        this.INSTRUMENTID_INDEX = 1;
        this.KEYOFDATA_INDEX = 2;
        this.HEADING_INDEX = 3;
        this.DIVISION_INDEX = 5;
    }

    public void setData(byte bPage) {
        String[] stringArray;
        if (bPage == 14) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "Value";
            stringArray2[1] = "%Chg";
            stringArray2[2] = "Open";
            stringArray2[3] = "High";
            stringArray2[4] = "Low";
            stringArray2[5] = "Close";
            stringArray = stringArray2;
            stringArray2[6] = "L U T";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "Value";
            stringArray3[1] = "Net Chg";
            stringArray3[2] = "%Chg";
            stringArray3[3] = "Open";
            stringArray3[4] = "High";
            stringArray = stringArray3;
            stringArray3[5] = "Low";
        }
        this.strHeadingData = stringArray;
    }

    public void setMarketInfoData(String[] marketInfoData) {
        this.iCurrentPageNo = 0;
        this.strValueData = marketInfoData;
    }

    public void paint(Graphics g) {
        int x = 2;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT + 2;
        int iFontHeight = AppConstants.FONT_HEADING.getHeight() + 1;
        g.setColor(0);
        g.fillRect(0, 0, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
        g.setColor(0xFFFFFF);
        g.setFont(AppConstants.FONT_HEADING);
        if (this.strValueData.length == 0 || this.strValueData == null) {
            g.drawString("No Data", 2, JPlatformCanvas.TITLE_BAR_HEIGHT + 2, 20);
            return;
        }
        g.drawString(this.strValueData[0], x, y, 20);
        int iHeadWidth = AppConstants.FONT_HEADING.stringWidth("Sell Qty ");
        int iMaxNoOfRows = (JPlatformCanvas.SCREEN_HEIGHT - (y += iFontHeight) - JPlatformCanvas.SOFT_KEYBAR_HEIGHT) / iFontHeight;
        this.iMaxPageNo = this.strHeadingData.length / iMaxNoOfRows;
        if (this.iMaxPageNo * iMaxNoOfRows < this.strHeadingData.length) {
            ++this.iMaxPageNo;
        }
        int iCurrentPageStartIndex = this.iCurrentPageNo * iMaxNoOfRows;
        for (int i = 0; i < iMaxNoOfRows; ++i) {
            if (i + iCurrentPageStartIndex >= this.strHeadingData.length) continue;
            x = 2;
            g.setFont(AppConstants.FONT_HEADING);
            g.drawString(this.strHeadingData[i + iCurrentPageStartIndex], x, y, 20);
            g.setFont(AppConstants.FONT_CONTENT);
            g.setColor(0xFFFFFF);
            g.drawString(": " + this.strValueData[i + iCurrentPageStartIndex + 1], x += iHeadWidth + 2, y, 20);
            y += iFontHeight;
        }
        this.canvas.setPageInfo("Pg: " + (this.iCurrentPageNo + 1) + "/" + this.iMaxPageNo);
    }

    public void paintScroller(Graphics g) {
        if (this.iCurrentPageNo != 0 && this.iCurrentPageNo <= this.iMaxPageNo - 1) {
            JPlatformCanvas.drawUpArrow(g);
        }
        if (this.iCurrentPageNo >= 0 && this.iCurrentPageNo != this.iMaxPageNo - 1) {
            JPlatformCanvas.drawDownArrow(g);
        }
    }

    public void keyPressed(int keycode) {
        try {
            switch (keycode) {
                case -1: 
                case 50: 
                case 221: {
                    --this.iCurrentPageNo;
                    if (this.iCurrentPageNo > 0) break;
                    this.iCurrentPageNo = 0;
                    break;
                }
                case -2: 
                case 56: 
                case 222: {
                    ++this.iCurrentPageNo;
                    if (this.iCurrentPageNo < this.iMaxPageNo) break;
                    this.iCurrentPageNo = this.iMaxPageNo - 1;
                }
            }
            JPlatformCanvas.getInstance().processSoftKeys(keycode);
        }
        catch (Exception e) {
            Utilities.printLog("ViewDetails-KeyPressed " + e.toString());
        }
    }

    public void pointerPressed(String lsSection, int x, int y) {
        if (lsSection.equals("HEADER")) {
            --this.iCurrentPageNo;
            if (this.iCurrentPageNo <= 0) {
                this.iCurrentPageNo = 0;
            }
        } else if (lsSection.equals("FOOTER")) {
            ++this.iCurrentPageNo;
            if (this.iCurrentPageNo >= this.iMaxPageNo) {
                this.iCurrentPageNo = this.iMaxPageNo - 1;
            }
        }
    }

    public boolean jcommandAction(SoftKey sk, Displayable d) {
        try {
            if (sk.getLabel().equals("Back") && iWinRefresh.iPreviousForm == 22) {
                iWinRefresh.getInstance().showform.showMarketInfo();
                return true;
            }
        }
        catch (Exception e) {
            Utilities.printLog("ViewDetails-CommandAction " + e.toString());
        }
        return true;
    }
}

