/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.TagData;
import common.Utilities;
import common.iWinDB;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import market.iWinRefresh;

public final class MarketWatch
implements JCommandListener {
    private String[][] strPrintData;
    private String[][] strData;
    private int[][] iColor;
    private int[][] iValue;
    private String[][] strIndexData;
    public int iCurrentIndex = 0;
    public int iMaxScriptsPerPage = 0;
    private int iPriceWidth;
    private int iMaxRows;
    private int iCountColumn = 0;
    public int iCurrentPageStartIndex = 0;
    private int iMaxNoOfScrips = -1;
    private int iDataRowStartY = 0;
    private int iDataRowEndY = 0;
    private int iRowHeight = 0;
    private final byte BUYQTY_INDEX;
    private final byte BUYPRICE_INDEX;
    private final byte SELLQTY_INDEX = (byte)2;
    private final byte SELLPRICE_INDEX = (byte)3;
    private final byte LTP_INDEX = (byte)4;
    private final byte LUT_INDEX = (byte)5;
    private final byte DIVISION_INDEX = (byte)6;
    private final byte PREVCLOSECOLOR_INDEX = (byte)6;
    private final byte SEGMENTID_INDEX;
    private final byte INSTRUMENTID_INDEX;
    private final byte KEYOFDATA_INDEX = (byte)2;
    private final byte HEADING_INDEX = (byte)3;
    private JPlatformCanvas canvas = JPlatformCanvas.getInstance();
    int[] columnList;

    public MarketWatch() {
        this.BUYQTY_INDEX = 0;
        this.BUYPRICE_INDEX = 1;
        this.SEGMENTID_INDEX = 0;
        this.INSTRUMENTID_INDEX = 1;
    }

    public void setCurrentIndex(int scripNo) {
        this.iCurrentIndex = scripNo;
    }

    public void setCurrentPageStartIndex(int index) {
        this.iCurrentPageStartIndex = index;
    }

    public int getMaxScriptsPerPages() {
        return this.iMaxScriptsPerPage;
    }

    public int getCurrentIndex() {
        return this.iCurrentIndex;
    }

    public void initializeVariableOnMarketWatch(String strPriceWidth) {
        boolean iBorderWidth = true;
        int iFontHeight = AppConstants.FONT_HEADING.getHeight();
        this.iPriceWidth = AppConstants.FONT_CONTENT.stringWidth(strPriceWidth) + 2;
        this.iMaxRows = 2;
        int x = this.iPriceWidth;
        for (int i = 1; i < 6; ++i) {
            if (x + this.iPriceWidth > JPlatformCanvas.SCREEN_WIDTH - 4) {
                ++this.iMaxRows;
                x = this.iPriceWidth;
                continue;
            }
            x += this.iPriceWidth;
        }
        if (this.iMaxRows == 2 && this.iPriceWidth * 3 < JPlatformCanvas.SCREEN_WIDTH - 12) {
            this.iPriceWidth += 3;
        }
        int iNoOfIndex = 0;
        int iIndexLength = 0;
        if (AppConstants.bBSEIndex) {
            iIndexLength = AppConstants.FONT_HEADING.stringWidth("SNX 00000.00(+000.00)");
            ++iNoOfIndex;
        }
        if (AppConstants.bNSEIndex) {
            iIndexLength += AppConstants.FONT_HEADING.stringWidth("NFY 00000.00(+000.00)");
            ++iNoOfIndex;
        }
        if (AppConstants.bMCXIndex && iNoOfIndex < 2) {
            iIndexLength += AppConstants.FONT_HEADING.stringWidth("MCXCOM 0000.00(+000.00)");
            ++iNoOfIndex;
        }
        if (AppConstants.bMCXSXIndex && iNoOfIndex < 2) {
            iIndexLength += AppConstants.FONT_HEADING.stringWidth("MCXSX40 0000.00(+000.00)");
            ++iNoOfIndex;
        }
        this.strIndexData = new String[iNoOfIndex][5];
        if (iIndexLength + 8 < JPlatformCanvas.SCREEN_WIDTH && iNoOfIndex == 2) {
            --iNoOfIndex;
        }
        this.iMaxScriptsPerPage = (JPlatformCanvas.SCREEN_HEIGHT - iFontHeight * iNoOfIndex - JPlatformCanvas.SOFT_KEYBAR_HEIGHT * 2) / (this.iMaxRows * (iFontHeight + 1) - 1);
        this.iCountColumn = 6 / (this.iMaxRows - 1);
    }

    public void Initialize(int ipNoOfScrips, TagData[] tag) {
        int i;
        this.strData = new String[ipNoOfScrips][4];
        this.iColor = new int[ipNoOfScrips][7];
        this.iValue = new int[ipNoOfScrips][7];
        this.strPrintData = new String[ipNoOfScrips][6];
        int printDataLength = this.strPrintData[0].length;
        for (i = 0; i < ipNoOfScrips; ++i) {
            this.strData[i][0] = Integer.toString(tag[i].iSegmentId);
            this.strData[i][1] = Integer.toString(tag[i].iInstrumentId);
            this.strData[i][2] = tag[i].strKeyOfData;
            this.strData[i][3] = tag[i].strScripDesc;
            for (int j = 0; j < printDataLength; ++j) {
                this.strPrintData[i][j] = "";
            }
            this.iValue[i][6] = tag[i].iDivisionFactor;
        }
        for (i = 0; i < this.strIndexData.length; ++i) {
            int indexDataLength = this.strIndexData[i].length;
            this.strIndexData[i][0] = Integer.toString(0);
            for (int j = 1; j < indexDataLength; ++j) {
                this.strIndexData[i][j] = "";
            }
        }
        this.columnList = null;
        if (AppConstants.iOrientation == 3) {
            iWinDB dbMarketwatch = new iWinDB("MVMOrientation");
            String[][] strOrientationList = dbMarketwatch.readRecordStore();
            this.columnList = new int[]{Integer.parseInt(strOrientationList[0][1]), Integer.parseInt(strOrientationList[1][1]), Integer.parseInt(strOrientationList[2][1]), Integer.parseInt(strOrientationList[3][1]), Integer.parseInt(strOrientationList[4][1]), Integer.parseInt(strOrientationList[5][1])};
        }
        this.iMaxNoOfScrips = ipNoOfScrips;
    }

    public String getCurrentScripName() {
        return this.strData[this.iCurrentIndex][3];
    }

    public void setIndexKey(int iKeyNo, TagData tag) {
        this.strIndexData[iKeyNo][0] = Integer.toString(0xFFFFFF);
        this.strIndexData[iKeyNo][1] = tag.strScripDesc;
        this.strIndexData[iKeyNo][2] = "0000.00";
        this.strIndexData[iKeyNo][3] = "";
        this.strIndexData[iKeyNo][4] = tag.strKeyOfData;
    }

    public void paint(Graphics dbGraphics) {
        int TL = 20;
        int TR = 24;
        int iStartX = 2;
        boolean iBorderWidth = true;
        boolean iV_SPACE = true;
        int iFontHeight = AppConstants.FONT_HEADING.getHeight();
        int x = 2;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT + 1;
        dbGraphics.setColor(0);
        dbGraphics.fillRect(0, 0, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
        dbGraphics.setFont(AppConstants.FONT_HEADING);
        int length = this.strIndexData.length;
        if (this.iMaxNoOfScrips <= 0) {
            dbGraphics.setColor(0xFFFFFF);
            dbGraphics.drawString("No Profiles Found", x, y, 20);
            return;
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                String strString = this.strIndexData[i][1] + " " + this.strIndexData[i][2] + this.strIndexData[i][3];
                int iWidth = AppConstants.FONT_HEADING.stringWidth(strString);
                if (i == 1) {
                    if (x + iWidth + 8 > JPlatformCanvas.SCREEN_WIDTH) {
                        x = 2;
                        y += iFontHeight;
                    } else {
                        x += 8;
                    }
                }
                dbGraphics.setColor(Integer.parseInt(this.strIndexData[i][0]));
                dbGraphics.drawString(strString, x, y, 20);
                dbGraphics.setColor(0xFFFFFF);
                dbGraphics.drawString(this.strIndexData[i][1], x, y, 20);
                x += iWidth;
            }
            y += iFontHeight;
        }
        int iCurrentPageIndex = this.iCurrentIndex / this.iMaxScriptsPerPage;
        this.iCurrentPageStartIndex = iCurrentPageIndex * this.iMaxScriptsPerPage;
        int iMaxPages = this.iMaxNoOfScrips / this.iMaxScriptsPerPage;
        iMaxPages = this.iMaxNoOfScrips != iMaxPages * this.iMaxScriptsPerPage ? iMaxPages + 1 : (iMaxPages == 0 ? 1 : iMaxPages);
        int iMaxDisplayRows = this.iMaxNoOfScrips - iCurrentPageIndex * this.iMaxScriptsPerPage < this.iMaxScriptsPerPage ? this.iMaxNoOfScrips - iCurrentPageIndex * this.iMaxScriptsPerPage : this.iMaxScriptsPerPage;
        this.iDataRowStartY = y;
        int iSelectorWidth = 0;
        int iSelectorY = 0;
        for (int i = 0; i < iMaxDisplayRows; ++i) {
            x = 2;
            switch (this.iColor[this.iCurrentPageStartIndex + i][6]) {
                case 4885759: {
                    dbGraphics.setColor(0x50FF50);
                    dbGraphics.fillTriangle(x, y + 1 + 11, x + 5, y + 1 + 1, x + 10, y + 1 + 11);
                    break;
                }
                case 0xFF5050: {
                    dbGraphics.setColor(0xFF5050);
                    dbGraphics.fillTriangle(x, y + 1 + 1, x + 5, y + 1 + 11, x + 10, y + 1 + 1);
                }
            }
            dbGraphics.setFont(AppConstants.FONT_HEADING);
            dbGraphics.setColor(0xFFFFFF);
            dbGraphics.drawString(this.strData[this.iCurrentPageStartIndex + i][3], x += 12, y + 1, 20);
            if (this.canvas.hasPointerEvents()) {
                ScreenPointerDefinition.setPointer(this.canvas.getTitle(), this.strData[this.iCurrentPageStartIndex + i][3], 0, y + 1 + 1, JPlatformCanvas.SCREEN_WIDTH, y + 1 + 1 + this.iMaxRows * iFontHeight + 1);
            }
            iSelectorY = y += iFontHeight;
            dbGraphics.setFont(AppConstants.FONT_CONTENT);
            for (int j = 0; j < this.iMaxRows - 1; ++j) {
                x = 2;
                for (int k = 0; k < this.iCountColumn; ++k) {
                    dbGraphics.setColor(0x7D7D7D);
                    dbGraphics.drawRect(x - 1, y - 1, this.iPriceWidth + 1, iFontHeight + 1);
                    dbGraphics.setColor(this.iCurrentIndex == this.iCurrentPageStartIndex + i & this.iColor[this.iCurrentPageStartIndex + i][k + j * this.iCountColumn] == 0 ? 0 : this.iColor[this.iCurrentPageStartIndex + i][k + j * this.iCountColumn]);
                    dbGraphics.fillRect(x, y, this.iPriceWidth, iFontHeight);
                    x += this.iPriceWidth;
                    if (this.strPrintData[this.iCurrentPageStartIndex + i][k + j * this.iCountColumn] == null) continue;
                    dbGraphics.setColor(0xFFFFFF);
                    dbGraphics.drawString(this.strPrintData[this.iCurrentPageStartIndex + i][k + j * this.iCountColumn], x - 1, y + 1, 24);
                }
                iSelectorWidth = x + 1;
                y += iFontHeight + 1;
            }
            if (this.iCurrentIndex != this.iCurrentPageStartIndex + i) continue;
            dbGraphics.setColor(15971078);
            dbGraphics.drawRect(0, iSelectorY + 1 + 1 - 2, iSelectorWidth, this.iMaxRows * iFontHeight - iFontHeight + 1);
        }
        this.iDataRowEndY = y;
        this.iRowHeight = (this.iDataRowEndY - this.iDataRowStartY) / iMaxDisplayRows;
        this.canvas.setPageInfo("Pg: " + (iCurrentPageIndex + 1) + "/" + iMaxPages);
        if (this.iCurrentPageStartIndex != AppConstants.PERVIOUS_PAGE) {
            AppConstants.sendrequest.stopTouchlineRequest(AppConstants.PERVIOUS_PAGE, this.iMaxScriptsPerPage, 0);
            AppConstants.sendrequest.startTouchlineRequest(this.iCurrentPageStartIndex, this.iMaxScriptsPerPage, 0);
            AppConstants.PERVIOUS_PAGE = this.iCurrentPageStartIndex;
        }
    }

    public boolean jcommandAction(SoftKey softKey, Displayable d) {
        if (softKey.getLabel().equals("Back")) {
            this.stop();
            iWinRefresh.getInstance().showform.showMainMenu();
            return true;
        }
        if (softKey.getLabel().equals("Select")) {
            iWinRefresh.iPreviousForm = 5;
            String strCommandName = this.canvas.getCommandName();
            if (strCommandName.equals("Market Depth")) {
                this.showBestFive();
                return true;
            }
            if (strCommandName.equals("Chart")) {
                AppConstants.FirstTime = true;
                if (this.strData.length == 0) {
                    return false;
                }
                AppConstants.strScrollCanvasHeading = this.strData[this.iCurrentIndex][3];
                AppConstants.strSearchString = "Chart";
                String strSegmentId = this.strData[this.iCurrentIndex][0];
                String strInstrumentId = this.strData[this.iCurrentIndex][1];
                String strKey = this.strData[this.iCurrentIndex][2];
                int iWidth = JPlatformCanvas.SCREEN_WIDTH;
                int iHeight = JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.TITLE_BAR_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT;
                this.stop();
                iWinRefresh.getInstance().showProgressBar();
                if (AppConstants.bCHARTS) {
                    AppConstants.iCurrentPage = (byte)34;
                    AppConstants.sendrequest.sendInteractiveChartRequest(strSegmentId, strInstrumentId, strKey, 0);
                } else {
                    AppConstants.sendrequest.sendChartRequest(strSegmentId, strInstrumentId, strKey, iWidth, iHeight);
                }
                return true;
            }
            if (strCommandName.equals("News")) {
                String strKey = this.strData[this.iCurrentIndex][2];
                this.stop();
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendScripWiseNewsRequest(strKey);
                return true;
            }
            if (strCommandName.equals("Set Alert")) {
                AppConstants.iCurrentPage = (byte)19;
                String strSegmentId = this.strData[this.iCurrentIndex][0];
                String strInstrumentId = this.strData[this.iCurrentIndex][1];
                String strKey = this.strData[this.iCurrentIndex][2] + "^" + this.iValue[this.iCurrentIndex][6] + "^" + this.strData[this.iCurrentIndex][3];
                this.stop();
                TagData tag = new TagData();
                tag.ExtractData(strSegmentId, strInstrumentId, strKey);
                iWinRefresh.getInstance().showform.showNewAlerts(tag, 0, "");
                return true;
            }
            if (strCommandName.equals("Add Scrip")) {
                if (AppConstants.STR_PROFILE_NAME.equals("")) {
                    iWinRefresh.displayAlert("MVMG", "Please create profile first", AppConstants.iAlertDisplayTime);
                    return false;
                }
                this.stop();
                iWinRefresh.iFirstForm = 5;
                iWinRefresh.getInstance().showform.showSelectInstrument(0);
                return true;
            }
            if (strCommandName.equals("Remove Scrip")) {
                if (this.strData.length == 0) {
                    return false;
                }
                if (this.strData.length == 1) {
                    iWinRefresh.displayAlert("MVMG", "Delete profile to remove the last record", AppConstants.iAlertDisplayTime);
                    return false;
                }
                String strSegmentId = this.strData[this.iCurrentIndex][0];
                String strInstrumentId = this.strData[this.iCurrentIndex][1];
                String strKey = this.strData[this.iCurrentIndex][2];
                this.stop();
                iWinRefresh.iFirstForm = 5;
                AppConstants.strRequestString = strKey;
                iWinRefresh.getInstance().showform.showCommonForm("Remove Scrip", strSegmentId, strInstrumentId, strKey, " ", " ", " ");
                return true;
            }
            if (strCommandName.equals("Set Alert")) {
                this.stop();
                iWinRefresh.iFirstForm = 5;
                iWinRefresh.getInstance().showform.showSelectInstrument(0);
                return true;
            }
            if (strCommandName.equals("Set Default")) {
                AppConstants.FromMarketwatch = true;
                int f_nProfileId = AppConstants.profilelist.getIdFromName(AppConstants.STR_PROFILE_NAME);
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendDefaultProfileRequest(f_nProfileId, "MARKETWATCH");
            } else if (strCommandName.equals("Profile")) {
                this.stop();
                iWinRefresh.getInstance().showform.showSelectProfile();
            } else {
                if (strCommandName.equals("Back")) {
                    this.stop();
                    iWinRefresh.getInstance().showform.showMainMenu();
                    this.iCurrentIndex = 0;
                    return true;
                }
                if (strCommandName.equals("Add To PMS")) {
                    iWinRefresh.iPreviousForm = 5;
                    String strSegmentId = this.strData[this.iCurrentIndex][0];
                    String strInstrumentId = this.strData[this.iCurrentIndex][1];
                    String strKey = this.strData[this.iCurrentIndex][2];
                    if (!(strInstrumentId.equals("-1") || strInstrumentId.equals("2") && (strSegmentId.equals("2") || strSegmentId.equals("9")) || (strInstrumentId.equals("1") || strInstrumentId.equals("2") || strInstrumentId.equals("3")) && (strSegmentId.equals("17") || strSegmentId.equals("12")))) {
                        AppConstants.IsAddOrRemove = "Add";
                        iWinRefresh.getInstance().showform.showSettings(2);
                        iWinRefresh.getInstance().showform.settings.setKeyInfo("", strSegmentId, strInstrumentId, strKey);
                    } else {
                        iWinRefresh.displayAlert("MVMG", "Scrip cannot be added to portfolio", AppConstants.iAlertDisplayTime);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void showBestFive() {
        if (this.strData.length == 0) {
            return;
        }
        AppConstants.iCurrentPage = (byte)24;
        AppConstants.sendrequest.stopTouchlineRequest(this.iCurrentPageStartIndex, this.iMaxScriptsPerPage, 0);
        AppConstants.sendrequest.startTouchlineRequest(this.iCurrentIndex, 1, 1);
        iWinRefresh.getInstance().showform.showBestFive(this.strData[this.iCurrentIndex], this.iValue[this.iCurrentIndex]);
    }

    public void stop() {
        AppConstants.sendrequest.stopTouchlineRequest(this.iCurrentPageStartIndex, this.iMaxScriptsPerPage, 0);
        AppConstants.sendrequest.startStopIndexRequest(1);
        this.iCurrentIndex = 0;
        AppConstants.PERVIOUS_PAGE = 0;
        this.iCurrentPageStartIndex = 0;
        AppConstants.bMarketWatchRequest = false;
    }

    public void SetData(int ipSegmentId, String strpKeyOfData, int ipBuyQty, int ipBuyPrice, int ipSellQty, int ipSellPrice, int ipLTP, int ipPrevClose, int ipLUT, int iDivisionFactor, int iOpen, int iHigh, int iLow) {
        try {
            int iCounter = this.iCurrentPageStartIndex + this.iMaxScriptsPerPage > this.iMaxNoOfScrips ? this.iMaxNoOfScrips : this.iCurrentPageStartIndex + this.iMaxScriptsPerPage;
            block1 : switch (AppConstants.iOrientation) {
                case 0: {
                    for (int i = this.iCurrentPageStartIndex; i < iCounter; ++i) {
                        if (!this.strData[i][2].startsWith(strpKeyOfData) || ipSegmentId != Integer.parseInt(this.strData[i][0])) continue;
                        iDivisionFactor = this.iValue[i][6];
                        int iSegmentId = Integer.parseInt(this.strData[i][0]);
                        int iOldBuyQty = this.iValue[i][0];
                        this.iValue[i][0] = ipBuyQty;
                        this.iColor[i][0] = ipBuyQty == 0 ? 0 : (ipBuyQty > iOldBuyQty ? 4885759 : (ipBuyQty < iOldBuyQty ? 0xFF5050 : 0));
                        int iOldBuyPrice = this.iValue[i][1];
                        this.iValue[i][1] = ipBuyPrice;
                        this.iColor[i][1] = ipBuyPrice == 0 ? 0 : (ipBuyPrice > iOldBuyPrice ? 4885759 : (ipBuyPrice < iOldBuyPrice ? 0xFF5050 : 0));
                        int iOldSellQty = this.iValue[i][2];
                        this.iValue[i][2] = ipSellQty;
                        this.iColor[i][2] = ipSellQty == 0 ? 0 : (ipSellQty > iOldSellQty ? 4885759 : (ipSellQty < iOldSellQty ? 0xFF5050 : 0));
                        int iOldSellPrice = this.iValue[i][3];
                        this.iValue[i][3] = ipSellPrice;
                        this.iColor[i][3] = ipSellPrice == 0 ? 0 : (ipSellPrice > iOldSellPrice ? 4885759 : (ipSellPrice < iOldSellPrice ? 0xFF5050 : 0));
                        int iOldLTP = this.iValue[i][4];
                        this.iValue[i][4] = ipLTP;
                        this.iColor[i][4] = ipLTP == 0 ? 0 : (ipLTP > iOldLTP ? 4885759 : (ipLTP < iOldLTP ? 0xFF5050 : 0));
                        this.iColor[i][6] = ipPrevClose > ipLTP ? 0xFF5050 : (ipPrevClose < ipLTP ? 4885759 : 0);
                        this.setMarketWatchData(i, ipBuyQty, ipBuyPrice, ipSellQty, ipSellPrice, ipLTP, ipLUT, ipPrevClose, iOpen, iHigh, iLow, iDivisionFactor, iSegmentId, ipLTP - ipPrevClose);
                        break block1;
                    }
                    break;
                }
                case 1: {
                    for (int i = this.iCurrentPageStartIndex; i < iCounter; ++i) {
                        int iNewNetChg;
                        if (!this.strData[i][2].startsWith(strpKeyOfData) || ipSegmentId != Integer.parseInt(this.strData[i][0])) continue;
                        iDivisionFactor = this.iValue[i][6];
                        int iSegmentId = Integer.parseInt(this.strData[i][0]);
                        if (iOpen != 0) {
                            this.iValue[i][0] = iOpen;
                        } else {
                            iOpen = this.iValue[i][0];
                        }
                        this.iColor[i][0] = 0;
                        if (iHigh != 0) {
                            this.iValue[i][1] = iHigh;
                        } else {
                            iHigh = this.iValue[i][1];
                        }
                        this.iColor[i][1] = 0;
                        if (iLow != 0) {
                            this.iValue[i][2] = iLow;
                        } else {
                            iLow = this.iValue[i][2];
                        }
                        this.iColor[i][2] = 0;
                        this.iValue[i][3] = iNewNetChg = ipLTP - ipPrevClose;
                        this.iColor[i][3] = 0;
                        int iOldLTP = this.iValue[i][4];
                        this.iValue[i][4] = ipLTP;
                        this.iColor[i][4] = ipLTP == 0 ? 0 : (ipLTP > iOldLTP ? 4885759 : (ipLTP < iOldLTP ? 0xFF5050 : 0));
                        this.iColor[i][6] = ipPrevClose > ipLTP ? 0xFF5050 : (ipPrevClose < ipLTP ? 4885759 : 0);
                        this.setMarketWatchData(i, ipBuyQty, ipBuyPrice, ipSellQty, ipSellPrice, ipLTP, ipLUT, ipPrevClose, iOpen, iHigh, iLow, iDivisionFactor, iSegmentId, iNewNetChg);
                        break block1;
                    }
                    break;
                }
                case 2: {
                    for (int i = this.iCurrentPageStartIndex; i < iCounter; ++i) {
                        if (!this.strData[i][2].startsWith(strpKeyOfData) || ipSegmentId != Integer.parseInt(this.strData[i][0])) continue;
                        iDivisionFactor = this.iValue[i][6];
                        int iSegmentId = Integer.parseInt(this.strData[i][0]);
                        int iOldBuyPrice = this.iValue[i][1];
                        this.iValue[i][1] = ipBuyPrice;
                        this.iColor[i][1] = ipBuyPrice == 0 ? 0 : (ipBuyPrice > iOldBuyPrice ? 4885759 : (ipBuyPrice < iOldBuyPrice ? 0xFF5050 : 0));
                        int iOldSellPrice = this.iValue[i][3];
                        this.iValue[i][3] = ipSellPrice;
                        this.iColor[i][3] = ipSellPrice == 0 ? 0 : (ipSellPrice > iOldSellPrice ? 4885759 : (ipSellPrice < iOldSellPrice ? 0xFF5050 : 0));
                        int iOldLTP = this.iValue[i][4];
                        this.iValue[i][4] = ipLTP;
                        int n = ipLTP == 0 ? 0 : (ipLTP > iOldLTP ? 4885759 : (this.iColor[i][4] = ipLTP < iOldLTP ? 0xFF5050 : 0));
                        if (iHigh != 0) {
                            this.iValue[i][0] = iHigh;
                        } else {
                            iHigh = this.iValue[i][0];
                        }
                        this.iColor[i][0] = 0;
                        if (iLow != 0) {
                            this.iValue[i][2] = iLow;
                        } else {
                            iLow = this.iValue[i][2];
                        }
                        this.iColor[i][2] = 0;
                        int iNewNetChg = ipLTP - ipPrevClose;
                        this.iColor[i][6] = ipPrevClose > ipLTP ? 0xFF5050 : (ipPrevClose < ipLTP ? 4885759 : 0);
                        this.setMarketWatchData(i, ipBuyQty, ipBuyPrice, ipSellQty, ipSellPrice, ipLTP, ipLUT, ipPrevClose, iOpen, iHigh, iLow, iDivisionFactor, iSegmentId, iNewNetChg);
                        break block1;
                    }
                    break;
                }
                case 3: {
                    for (int i = this.iCurrentPageStartIndex; i < iCounter; ++i) {
                        if (!this.strData[i][2].startsWith(strpKeyOfData) || ipSegmentId != Integer.parseInt(this.strData[i][0])) continue;
                        iDivisionFactor = this.iValue[i][6];
                        int iSegmentId = Integer.parseInt(this.strData[i][0]);
                        block22: for (int j = 0; j < this.columnList.length; ++j) {
                            int columnNumber = this.columnList[j];
                            switch (columnNumber) {
                                case 0: {
                                    int iOldBuyPrice = this.iValue[i][j];
                                    this.iValue[i][j] = ipBuyPrice;
                                    this.iColor[i][j] = ipBuyPrice == 0 ? 0 : (ipBuyPrice > iOldBuyPrice ? 4885759 : (ipBuyPrice < iOldBuyPrice ? 0xFF5050 : 0));
                                    continue block22;
                                }
                                case 1: {
                                    int iOldBuyQty = this.iValue[i][j];
                                    this.iValue[i][j] = ipBuyQty;
                                    this.iColor[i][j] = ipBuyQty == 0 ? 0 : (ipBuyQty > iOldBuyQty ? 4885759 : (ipBuyQty < iOldBuyQty ? 0xFF5050 : 0));
                                    continue block22;
                                }
                                case 2: {
                                    int iOldSellPrice = this.iValue[i][j];
                                    this.iValue[i][j] = ipSellPrice;
                                    this.iColor[i][j] = ipSellPrice == 0 ? 0 : (ipSellPrice > iOldSellPrice ? 4885759 : (ipSellPrice < iOldSellPrice ? 0xFF5050 : 0));
                                    continue block22;
                                }
                                case 3: {
                                    int iOldSellQty = this.iValue[i][j];
                                    this.iValue[i][j] = ipSellQty;
                                    this.iColor[i][j] = ipSellQty == 0 ? 0 : (ipSellQty > iOldSellQty ? 4885759 : (ipSellQty < iOldSellQty ? 0xFF5050 : 0));
                                    continue block22;
                                }
                                case 4: {
                                    int iOldLTP = this.iValue[i][j];
                                    this.iValue[i][j] = ipLTP;
                                    this.iColor[i][j] = ipLTP == 0 ? 0 : (ipLTP > iOldLTP ? 4885759 : (ipLTP < iOldLTP ? 0xFF5050 : 0));
                                    continue block22;
                                }
                                case 6: {
                                    if (iOpen != 0) {
                                        this.iValue[i][j] = iOpen;
                                    } else {
                                        iOpen = this.iValue[i][j];
                                    }
                                    this.iColor[i][j] = 0;
                                    continue block22;
                                }
                                case 7: {
                                    if (iHigh != 0) {
                                        this.iValue[i][j] = iHigh;
                                    } else {
                                        iHigh = this.iValue[i][j];
                                    }
                                    this.iColor[i][j] = 0;
                                    continue block22;
                                }
                                case 8: {
                                    if (iLow != 0) {
                                        this.iValue[i][j] = iLow;
                                    } else {
                                        iLow = this.iValue[i][j];
                                    }
                                    this.iColor[i][j] = 0;
                                }
                            }
                        }
                        int iNewNetChg = ipLTP - ipPrevClose;
                        this.iColor[i][6] = ipPrevClose > ipLTP ? 0xFF5050 : (ipPrevClose < ipLTP ? 4885759 : 0);
                        this.setMarketWatchData(i, ipBuyQty, ipBuyPrice, ipSellQty, ipSellPrice, ipLTP, ipLUT, ipPrevClose, iOpen, iHigh, iLow, iDivisionFactor, iSegmentId, iNewNetChg);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Utilities.printLog("MW-SetData " + e.toString());
        }
        AppConstants.profilelist.checkAlerts(strpKeyOfData, ipLTP, ipLUT);
        this.canvas.refreshDisplay();
    }

    private void setMarketWatchData(int iCurrentRow, int ipBuyQty, int ipBuyPrice, int ipSellQty, int ipSellPrice, int ipLTP, int ipLUT, int ipPreviousClose, int iOpen, int iHigh, int iLow, int iDivisionFactor, int ipSegmentId, int ipNetChg) {
        int iBuyQtyColor = this.iColor[iCurrentRow][0];
        int iSellQtyColor = this.iColor[iCurrentRow][2];
        int iBuyPriceColor = this.iColor[iCurrentRow][1];
        int iSellPriceColor = this.iColor[iCurrentRow][3];
        int iLTPColor = this.iColor[iCurrentRow][4];
        String strNetChg = "";
        if (ipNetChg < 0) {
            strNetChg = Utilities.ConvertToDecimal(-1 * ipNetChg, iDivisionFactor, ipSegmentId);
            strNetChg = "-" + strNetChg;
        } else if (ipNetChg > 0) {
            strNetChg = Utilities.ConvertToDecimal(ipNetChg, iDivisionFactor, ipSegmentId);
            strNetChg = "+" + strNetChg;
        }
        block0 : switch (this.iMaxRows) {
            case 2: {
                switch (AppConstants.iOrientation) {
                    case 0: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ToString(ipBuyQty);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = Utilities.ToString(ipSellQty);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(ipLUT);
                        this.iColor[iCurrentRow][0] = iBuyQtyColor;
                        this.iColor[iCurrentRow][1] = iBuyPriceColor;
                        this.iColor[iCurrentRow][2] = iSellPriceColor;
                        this.iColor[iCurrentRow][3] = iSellQtyColor;
                        this.iColor[iCurrentRow][4] = iLTPColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break;
                    }
                    case 1: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = strNetChg;
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(ipLUT);
                        this.iColor[iCurrentRow][0] = iLTPColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iBuyQtyColor;
                        this.iColor[iCurrentRow][3] = iBuyPriceColor;
                        this.iColor[iCurrentRow][4] = iSellQtyColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break;
                    }
                    case 2: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = strNetChg;
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                        this.iColor[iCurrentRow][0] = iBuyPriceColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iLTPColor;
                        this.iColor[iCurrentRow][3] = iSellQtyColor;
                        this.iColor[iCurrentRow][4] = iBuyQtyColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break;
                    }
                    case 3: {
                        block78: for (int j = 0; j < this.columnList.length; ++j) {
                            int columnNumber = this.columnList[j];
                            switch (columnNumber) {
                                case 0: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                                    continue block78;
                                }
                                case 1: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipBuyQty);
                                    continue block78;
                                }
                                case 2: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                                    continue block78;
                                }
                                case 3: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipSellQty);
                                    continue block78;
                                }
                                case 4: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                                    continue block78;
                                }
                                case 5: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.GetFormattedTime(ipLUT);
                                    continue block78;
                                }
                                case 6: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                                    continue block78;
                                }
                                case 7: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                                    continue block78;
                                }
                                case 8: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                                    continue block78;
                                }
                                case 9: {
                                    this.strPrintData[iCurrentRow][j] = strNetChg;
                                }
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (AppConstants.iOrientation) {
                    case 0: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = Utilities.ToString(ipBuyQty);
                        this.strPrintData[iCurrentRow][4] = Utilities.ToString(ipSellQty);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(ipLUT);
                        this.iColor[iCurrentRow][0] = iBuyPriceColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iLTPColor;
                        this.iColor[iCurrentRow][3] = iBuyQtyColor;
                        this.iColor[iCurrentRow][4] = iSellQtyColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break;
                    }
                    case 1: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = strNetChg;
                        this.strPrintData[iCurrentRow][2] = Utilities.GetFormattedTime(ipLUT);
                        this.strPrintData[iCurrentRow][3] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                        this.iColor[iCurrentRow][0] = iLTPColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = 0;
                        this.iColor[iCurrentRow][3] = iBuyQtyColor;
                        this.iColor[iCurrentRow][4] = iBuyPriceColor;
                        this.iColor[iCurrentRow][5] = iSellQtyColor;
                        break;
                    }
                    case 2: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = strNetChg;
                        this.iColor[iCurrentRow][0] = iBuyPriceColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iLTPColor;
                        this.iColor[iCurrentRow][3] = iBuyQtyColor;
                        this.iColor[iCurrentRow][4] = 0;
                        this.iColor[iCurrentRow][5] = iSellQtyColor;
                        break;
                    }
                    case 3: {
                        block79: for (int j = 0; j < this.columnList.length; ++j) {
                            int columnNumber = this.columnList[j];
                            switch (columnNumber) {
                                case 0: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                                    continue block79;
                                }
                                case 1: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipBuyQty);
                                    continue block79;
                                }
                                case 2: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                                    continue block79;
                                }
                                case 3: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipSellQty);
                                    continue block79;
                                }
                                case 4: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                                    continue block79;
                                }
                                case 5: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.GetFormattedTime(ipLUT);
                                    continue block79;
                                }
                                case 6: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                                    continue block79;
                                }
                                case 7: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                                    continue block79;
                                }
                                case 8: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                                    continue block79;
                                }
                                case 9: {
                                    this.strPrintData[iCurrentRow][j] = strNetChg;
                                }
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case 4: {
                switch (AppConstants.iOrientation) {
                    case 0: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ToString(ipBuyQty);
                        this.strPrintData[iCurrentRow][3] = Utilities.ToString(ipSellQty);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(ipLUT);
                        this.iColor[iCurrentRow][0] = iBuyPriceColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iBuyQtyColor;
                        this.iColor[iCurrentRow][3] = iSellQtyColor;
                        this.iColor[iCurrentRow][4] = iLTPColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break;
                    }
                    case 1: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = strNetChg;
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(ipLUT);
                        this.iColor[iCurrentRow][0] = iLTPColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iBuyPriceColor;
                        this.iColor[iCurrentRow][3] = iBuyQtyColor;
                        this.iColor[iCurrentRow][4] = iSellQtyColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break;
                    }
                    case 2: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = strNetChg;
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                        this.iColor[iCurrentRow][0] = iBuyPriceColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iLTPColor;
                        this.iColor[iCurrentRow][3] = iSellQtyColor;
                        this.iColor[iCurrentRow][4] = iBuyQtyColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break;
                    }
                    case 3: {
                        block80: for (int j = 0; j < this.columnList.length; ++j) {
                            int columnNumber = this.columnList[j];
                            switch (columnNumber) {
                                case 0: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                                    continue block80;
                                }
                                case 1: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipBuyQty);
                                    continue block80;
                                }
                                case 2: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                                    continue block80;
                                }
                                case 3: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipSellQty);
                                    continue block80;
                                }
                                case 4: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                                    continue block80;
                                }
                                case 5: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.GetFormattedTime(ipLUT);
                                    continue block80;
                                }
                                case 6: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                                    continue block80;
                                }
                                case 7: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                                    continue block80;
                                }
                                case 8: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                                    continue block80;
                                }
                                case 9: {
                                    this.strPrintData[iCurrentRow][j] = strNetChg;
                                }
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (AppConstants.iOrientation) {
                    case 0: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ToString(ipBuyQty);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ToString(ipSellQty);
                        this.strPrintData[iCurrentRow][3] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(ipLUT);
                        this.iColor[iCurrentRow][0] = iBuyQtyColor;
                        this.iColor[iCurrentRow][1] = iBuyPriceColor;
                        this.iColor[iCurrentRow][2] = iSellQtyColor;
                        this.iColor[iCurrentRow][3] = iSellPriceColor;
                        this.iColor[iCurrentRow][4] = iLTPColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break block0;
                    }
                    case 1: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = strNetChg;
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(ipLUT);
                        this.iColor[iCurrentRow][0] = iLTPColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iBuyQtyColor;
                        this.iColor[iCurrentRow][3] = iBuyPriceColor;
                        this.iColor[iCurrentRow][4] = iSellQtyColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break block0;
                    }
                    case 2: {
                        this.strPrintData[iCurrentRow][0] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][1] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][2] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][3] = strNetChg;
                        this.strPrintData[iCurrentRow][4] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                        this.strPrintData[iCurrentRow][5] = Utilities.GetFormattedTime(iLow);
                        this.iColor[iCurrentRow][0] = iBuyPriceColor;
                        this.iColor[iCurrentRow][1] = iSellPriceColor;
                        this.iColor[iCurrentRow][2] = iLTPColor;
                        this.iColor[iCurrentRow][3] = iSellQtyColor;
                        this.iColor[iCurrentRow][4] = iBuyQtyColor;
                        this.iColor[iCurrentRow][5] = 0;
                        break block0;
                    }
                    case 3: {
                        block81: for (int j = 0; j < this.columnList.length; ++j) {
                            int columnNumber = this.columnList[j];
                            switch (columnNumber) {
                                case 0: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipBuyPrice, iDivisionFactor, ipSegmentId);
                                    continue block81;
                                }
                                case 1: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipBuyQty);
                                    continue block81;
                                }
                                case 2: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipSellPrice, iDivisionFactor, ipSegmentId);
                                    continue block81;
                                }
                                case 3: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ToString(ipSellQty);
                                    continue block81;
                                }
                                case 4: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(ipLTP, iDivisionFactor, ipSegmentId);
                                    continue block81;
                                }
                                case 5: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.GetFormattedTime(ipLUT);
                                    continue block81;
                                }
                                case 6: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, ipSegmentId);
                                    continue block81;
                                }
                                case 7: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, ipSegmentId);
                                    continue block81;
                                }
                                case 8: {
                                    this.strPrintData[iCurrentRow][j] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, ipSegmentId);
                                    continue block81;
                                }
                                case 9: {
                                    this.strPrintData[iCurrentRow][j] = strNetChg;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void pointerPressed(String lsSection, int x, int y) {
        this.iCurrentIndex = lsSection.equals("HEADER") ? ((this.iCurrentIndex - 1) % this.iMaxNoOfScrips + this.iMaxNoOfScrips) % this.iMaxNoOfScrips : (lsSection.equals("FOOTER") ? (this.iCurrentIndex + 1) % this.iMaxNoOfScrips : (y > this.iDataRowStartY && y < this.iDataRowEndY ? this.iCurrentPageStartIndex + (this.iRowHeight > 0 ? (y - this.iDataRowStartY) / this.iRowHeight : 0) : 0));
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -1: 
            case 50: 
            case 221: {
                this.iCurrentIndex = ((this.iCurrentIndex - 1) % this.iMaxNoOfScrips + this.iMaxNoOfScrips) % this.iMaxNoOfScrips;
                break;
            }
            case -2: 
            case 56: 
            case 222: {
                this.iCurrentIndex = (this.iCurrentIndex + 1) % this.iMaxNoOfScrips;
                break;
            }
            case 54: 
            case 206: {
                this.showBestFive();
                break;
            }
            default: {
                this.canvas.processSoftKeys(keyCode);
            }
        }
    }

    public void SetIndex(String strKey, int ipIndexValue, int ipPreviousCloseValue, int ipDivisionFactor, int ipSegmentId, int iMsgTimeStamp, int iOpen, int iHigh, int iLow) {
        int length = this.strIndexData.length;
        for (int i = 0; i < length; ++i) {
            if (!this.strIndexData[i][4].startsWith(strKey)) continue;
            String strIndexValue = Utilities.ConvertToDecimal(ipIndexValue, ipDivisionFactor, ipSegmentId);
            String strIndexChange = "";
            int iColor = 0;
            if (ipIndexValue > ipPreviousCloseValue) {
                strIndexChange = "+" + Utilities.ConvertToDecimal(ipIndexValue - ipPreviousCloseValue, ipDivisionFactor, ipSegmentId);
                iColor = 4885759;
            } else if (ipIndexValue < ipPreviousCloseValue) {
                strIndexChange = "-" + Utilities.ConvertToDecimal(ipPreviousCloseValue - ipIndexValue, ipDivisionFactor, ipSegmentId);
                iColor = 0xFF5050;
            } else {
                strIndexChange = "0.00";
                iColor = 0xFFFFFF;
            }
            this.strIndexData[i][2] = strIndexValue;
            this.strIndexData[i][3] = "(" + strIndexChange + ")";
            this.strIndexData[i][0] = Integer.toString(iColor);
            break;
        }
        this.SetData(ipSegmentId, strKey, 0, 0, 0, 0, ipIndexValue, ipPreviousCloseValue, iMsgTimeStamp, ipDivisionFactor, iOpen, iHigh, iLow);
    }
}

