/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Profile;
import common.TagData;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import market.iWinRefresh;

public class CommonCanvas
implements JCommandListener,
Runnable {
    private String[][] strData;
    private int iCurrentIndex = 0;
    private int iMaxPageNo = 0;
    private int iFontHeight = AppConstants.FONT_HEADING.getHeight() + 1;
    private Thread t;
    private int iHeadingX = 2;
    private int iCurrentPage = 0;
    private int iTotalPage = 0;
    private int iTotalLines = 1;
    private int iHeadingWidth = 0;
    private String title;
    private boolean isBlankForm = false;

    public void setData(String[][] strpData, int ipCurrentPage, int ipTotalPage, String strpFormName) {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
        this.isBlankForm = false;
        this.iCurrentIndex = 0;
        this.iHeadingWidth = 0;
        this.iHeadingX = 2;
        this.strData = strpData;
        if (this.strData.length == 0 || this.strData == null) {
            this.isBlankForm = true;
        }
        this.iCurrentPage = ipCurrentPage;
        this.iTotalPage = ipTotalPage;
        this.setTitle(strpFormName);
    }

    public void paint(Graphics g) {
        int x = 2;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT + 8;
        int iCurrentPageNo = 0;
        int iMaxWidth = JPlatformCanvas.SCREEN_WIDTH;
        int iMaxHeight = JPlatformCanvas.SCREEN_HEIGHT;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, iMaxWidth, iMaxHeight);
        if (this.strData.length == 0 || this.strData == null) {
            g.setColor(0);
            g.setFont(AppConstants.FONT_HEADING);
            g.drawString("No Data", x, y, 20);
            return;
        }
        this.iTotalLines = (iMaxHeight - y - JPlatformCanvas.SOFT_KEYBAR_HEIGHT) / this.iFontHeight - 1;
        iCurrentPageNo = this.iCurrentIndex / this.iTotalLines;
        int iColorIndex = this.iCurrentIndex % this.iTotalLines;
        this.iMaxPageNo = this.strData.length / this.iTotalLines;
        if (this.iMaxPageNo * this.iTotalLines < this.strData.length) {
            ++this.iMaxPageNo;
        }
        this.iHeadingWidth = AppConstants.FONT_HEADING.stringWidth(this.strData[this.iCurrentIndex][0]);
        int iCurrentPageStartIndex = iCurrentPageNo * this.iTotalLines;
        for (int i = 0; i < this.iTotalLines; ++i) {
            if (iCurrentPageStartIndex + i < this.strData.length) {
                g.setFont(AppConstants.FONT_HEADING);
                if (i == iColorIndex) {
                    g.setColor(1132180);
                    g.fillRect(0, y, iMaxWidth, this.iFontHeight);
                    g.setColor(0xFFFFFF);
                    g.drawString(this.strData[i + iCurrentPageStartIndex][0], this.iHeadingX, y, 20);
                } else if (i % 2 == 0) {
                    g.setColor(0xCCCC99);
                    g.fillRect(0, y, iMaxWidth, this.iFontHeight);
                    g.setColor(0);
                    g.drawString(this.strData[i + iCurrentPageStartIndex][0], x, y, 20);
                } else {
                    g.setColor(0);
                    g.drawString(this.strData[i + iCurrentPageStartIndex][0], x, y, 20);
                }
                y += this.iFontHeight;
            }
            if (!JPlatformCanvas.getInstance().hasPointerEvents() || iCurrentPageStartIndex + i >= this.strData.length) continue;
            ScreenPointerDefinition.setPointer(this.getTitle(), this.strData[i + iCurrentPageStartIndex][0], x, y - this.iFontHeight, JPlatformCanvas.SCREEN_WIDTH, y);
        }
        g.setColor(0);
        if (!(this.getTitle().equals("Profile Scrips") || this.getTitle().equals("Alert History") || this.getTitle().equals("Modify Alerts"))) {
            g.drawString("Page [" + this.iCurrentPage + "/" + this.iTotalPage + "]", 2, iMaxHeight - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - 2, 36);
        }
        g.drawString(iCurrentPageNo + 1 + "/" + this.iMaxPageNo, iMaxWidth - 2, iMaxHeight - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - 2, 40);
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Select")) {
            String strCommandFromList = JPlatformCanvas.getInstance().getCommandName();
            if (this.getTitle().equals("Profile Scrips")) {
                if (strCommandFromList.equals("MoveUp")) {
                    if (this.iCurrentIndex == 0) {
                        return false;
                    }
                    String strProfileId = Integer.toString(AppConstants.SELECT_PROFILE_INDEX);
                    Profile profile = AppConstants.profilelist.getData(strProfileId);
                    TagData[] tag = profile.getTagData();
                    --this.iCurrentIndex;
                    TagData tempTag = tag[this.iCurrentIndex];
                    tag[this.iCurrentIndex] = tag[this.iCurrentIndex + 1];
                    tag[this.iCurrentIndex + 1] = tempTag;
                    profile = new Profile(AppConstants.SELECT_PROFILE_INDEX, AppConstants.STR_PROFILE_NAME, "MARKETWTCH", tag);
                    AppConstants.profilelist.putData(strProfileId, profile);
                    for (int i = 0; i < this.strData[this.iCurrentIndex].length; ++i) {
                        String strTemp = this.strData[this.iCurrentIndex][i];
                        this.strData[this.iCurrentIndex][i] = this.strData[this.iCurrentIndex + 1][i];
                        this.strData[this.iCurrentIndex + 1][i] = strTemp;
                    }
                    iWinRefresh.getInstance().showform.showCommonCanvas();
                    return true;
                }
                if (strCommandFromList.equals("MoveDown")) {
                    if (this.iCurrentIndex == this.strData.length - 1) {
                        return false;
                    }
                    String strProfileId = Integer.toString(AppConstants.SELECT_PROFILE_INDEX);
                    Profile profile = AppConstants.profilelist.getData(strProfileId);
                    TagData[] tag = profile.getTagData();
                    ++this.iCurrentIndex;
                    TagData tempTag = tag[this.iCurrentIndex];
                    tag[this.iCurrentIndex] = tag[this.iCurrentIndex - 1];
                    tag[this.iCurrentIndex - 1] = tempTag;
                    profile = new Profile(AppConstants.SELECT_PROFILE_INDEX, AppConstants.STR_PROFILE_NAME, "MARKETWTCH", tag);
                    AppConstants.profilelist.putData(strProfileId, profile);
                    for (int i = 0; i < this.strData[this.iCurrentIndex].length; ++i) {
                        String strTemp = this.strData[this.iCurrentIndex][i];
                        this.strData[this.iCurrentIndex][i] = this.strData[this.iCurrentIndex - 1][i];
                        this.strData[this.iCurrentIndex - 1][i] = strTemp;
                    }
                    iWinRefresh.getInstance().showform.showCommonCanvas();
                    return true;
                }
                if (strCommandFromList.equals("Set Alert")) {
                    iWinRefresh.iPreviousForm = 6;
                    AppConstants.iCurrentPage = (byte)19;
                    String strProfileId = Integer.toString(AppConstants.SELECT_PROFILE_INDEX);
                    Profile profile = AppConstants.profilelist.getData(strProfileId);
                    TagData[] tag = profile.getTagData();
                    TagData tempTag = new TagData();
                    for (int i = 0; i < tag.length; ++i) {
                        if (!tag[i].strKeyOfData.equals(this.strData[this.iCurrentIndex][3])) continue;
                        tempTag = tag[i];
                        break;
                    }
                    this.dispose();
                    iWinRefresh.getInstance().showform.showNewAlerts(tempTag, 0, "");
                    return true;
                }
                if (strCommandFromList.equals("Add")) {
                    iWinRefresh.iPreviousForm = 6;
                    iWinRefresh.getInstance().showform.showSelectInstrument(0);
                    this.dispose();
                    return true;
                }
                if (strCommandFromList.equals("Remove")) {
                    if (this.strData.length == 1) {
                        iWinRefresh.displayAlert("MVMG", "Delete profile to remove the last record", AppConstants.iAlertDisplayTime);
                        return false;
                    }
                    AppConstants.strRequestString = this.strData[this.iCurrentIndex][3];
                    iWinRefresh.getInstance().showform.showCommonForm("Remove Scrip", this.strData[this.iCurrentIndex][1], this.strData[this.iCurrentIndex][2], this.strData[this.iCurrentIndex][3], " ", " ", " ");
                    this.dispose();
                    return true;
                }
                if (strCommandFromList.equals("Save")) {
                    StringBuffer strProfileData = new StringBuffer();
                    for (int i = 0; i < this.strData.length; ++i) {
                        strProfileData.append(this.strData[i][1]).append("^").append(this.strData[i][2]).append("^").append(this.strData[i][3]).append("$");
                    }
                    String strTemp = strProfileData.toString();
                    if (strTemp.endsWith("$")) {
                        strTemp = strTemp.substring(0, strTemp.length() - 1);
                    }
                    AppConstants.sendrequest.sendSaveRequest(AppConstants.STR_PROFILE_NAME, strTemp);
                    iWinRefresh.getInstance().showform.showCommonCanvas();
                    return true;
                }
            } else if (this.getTitle().equals("Modify Alerts")) {
                iWinRefresh.iPreviousForm = 18;
                if (this.strData.length <= 0) {
                    return false;
                }
                if (strCommandFromList.equals("Modify")) {
                    String[] strTemp = Utilities.split(this.strData[this.iCurrentIndex][0], " ");
                    TagData tag = AppConstants.profilelist.getAlert(this.strData[this.iCurrentIndex][1]);
                    iWinRefresh.getInstance().showform.showNewAlerts(tag, this.getCondition(strTemp[strTemp.length - 2]), strTemp[strTemp.length - 1]);
                    this.dispose();
                    return true;
                }
                if (strCommandFromList.equals("Remove")) {
                    String[] strTemp = Utilities.split(this.strData[this.iCurrentIndex][0], " ");
                    TagData tag = AppConstants.profilelist.getAlert(this.strData[this.iCurrentIndex][1]);
                    String strPrice = (String)tag.htAlerts.get(Integer.toString(this.getCondition(strTemp[strTemp.length - 2])));
                    tag.iPrice = Integer.parseInt(strPrice);
                    AppConstants.strRequestString = Integer.toString(this.getCondition(strTemp[strTemp.length - 2]));
                    AppConstants.sendrequest.sendAddOrRemoveAlertRequest(tag.iSegmentId, tag.iInstrumentId, tag.strKeyOfData, this.getCondition(strTemp[strTemp.length - 2]), tag.iPrice, 2);
                    this.dispose();
                    return true;
                }
            } else {
                if (strCommandFromList.equals("AddToPMS")) {
                    AppConstants.IsAddOrRemove = "Add";
                    if (this.strData == null || this.strData.length == 0) {
                        return false;
                    }
                    iWinRefresh.iPreviousForm = 6;
                    String[] strTempArray = Utilities.split(this.strData[this.iCurrentIndex][2], "^");
                    iWinRefresh.getInstance().showform.showSettings(2);
                    iWinRefresh.getInstance().showform.settings.setKeyInfo(this.strData[this.iCurrentIndex][0], strTempArray[0], strTempArray[1], strTempArray[2]);
                    return true;
                }
                if (strCommandFromList.equals("Details")) {
                    iWinRefresh.getInstance().showform.showCommonForm(this.getTitle(), "", "", this.strData[this.iCurrentIndex][1], "", "", "");
                    return true;
                }
                if (strCommandFromList.equals("Next")) {
                    if (this.iMaxPageNo == 0) {
                        return false;
                    }
                    if (this.iCurrentPage >= this.iTotalPage) {
                        return false;
                    }
                    this.dispose();
                    ++this.iCurrentPage;
                    iWinRefresh.getInstance().showProgressBar();
                    AppConstants.sendrequest.sendIPOMutualFundRequest(AppConstants.iListIndex, this.iCurrentPage, AppConstants.strFundName, AppConstants.strSchemeName);
                    return true;
                }
                if (strCommandFromList.equals("Prev")) {
                    if (this.iMaxPageNo == 0) {
                        return false;
                    }
                    if (this.iCurrentPage <= 1) {
                        this.iCurrentPage = 1;
                        return false;
                    }
                    --this.iCurrentPage;
                    this.dispose();
                    iWinRefresh.getInstance().showProgressBar();
                    AppConstants.sendrequest.sendIPOMutualFundRequest(AppConstants.iListIndex, this.iCurrentPage, AppConstants.strFundName, AppConstants.strSchemeName);
                    return true;
                }
                if (strCommandFromList.equals("Menu")) {
                    iWinRefresh.getInstance().showform.showMainMenu();
                    this.dispose();
                    return true;
                }
                if (strCommandFromList.equals("Back")) {
                    this.actionAtBackPress();
                    return true;
                }
            }
        } else if (softkey.getLabel().equals("Back")) {
            if (this.getTitle().equals("Profile Scrips")) {
                this.dispose();
                iWinRefresh.getInstance().showform.showProfile();
            } else {
                this.actionAtBackPress();
            }
            return true;
        }
        return true;
    }

    private int getCondition(String strCondition) {
        if (strCondition.equals(">")) {
            return 10;
        }
        if (strCondition.equals("<")) {
            return 11;
        }
        return 12;
    }

    private void actionAtBackPress() {
        this.dispose();
        if (this.getTitle().equals("Mutual Fund")) {
            iWinRefresh.getInstance().showform.showMutualFund();
        } else if (this.getTitle().equals("Insurance")) {
            iWinRefresh.getInstance().showform.showMainMenu();
        } else if (this.getTitle().equals("IPO")) {
            iWinRefresh.getInstance().showform.showIPO();
        } else if (this.getTitle().equals("Alert History") || this.getTitle().equals("Modify Alerts")) {
            iWinRefresh.getInstance().showform.showAlerts();
        }
    }

    public void run() {
        try {
            while (AppConstants.bCommonCanvasThread) {
                if (JPlatformCanvas.getInstance().getScreenID() == 6) {
                    if (this.iHeadingWidth > JPlatformCanvas.SCREEN_WIDTH - 4) {
                        JPlatformCanvas.getInstance().repaint();
                        this.iHeadingX = this.iHeadingX + this.iHeadingWidth > 3 * (JPlatformCanvas.SCREEN_WIDTH >> 2) ? --this.iHeadingX : JPlatformCanvas.SCREEN_WIDTH >> 2;
                    } else {
                        this.iHeadingX = 2;
                    }
                }
                Thread.sleep(25L);
            }
        }
        catch (Exception e) {
            Utilities.printLog("CommonCanvas-run " + e.toString());
        }
    }

    public void setTitle(String Title) {
        this.title = Title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isBlankForm() {
        return this.isBlankForm;
    }

    public void keyPressed(int keycode) {
        switch (keycode) {
            case 56: 
            case 222: {
                ++this.iCurrentIndex;
                if (this.iCurrentIndex > this.strData.length - 1) {
                    this.iCurrentIndex = 0;
                }
                this.iHeadingX = 2;
                break;
            }
            case 50: 
            case 221: {
                --this.iCurrentIndex;
                if (this.iCurrentIndex < 0) {
                    this.iCurrentIndex = this.strData.length - 1;
                }
                this.iHeadingX = 2;
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keycode);
            }
        }
    }

    public void pointerPressed(String lsSection, int x, int y) {
        block3: {
            block4: {
                block2: {
                    if (!lsSection.equals("HEADER")) break block2;
                    --this.iCurrentIndex;
                    if (this.iCurrentIndex >= 0) break block3;
                    this.iCurrentIndex = this.strData.length - 1;
                    break block3;
                }
                if (!lsSection.equals("FOOTER")) break block4;
                ++this.iCurrentIndex;
                if (this.iCurrentIndex <= this.strData.length - 1) break block3;
                this.iCurrentIndex = 0;
                break block3;
            }
            if (this.strData != null && this.strData.length > 0) {
                for (int i = 0; i < this.strData.length; ++i) {
                    if (!this.strData[i][0].equals(lsSection)) continue;
                    this.iCurrentIndex = i;
                    break;
                }
            }
        }
        this.iHeadingX = 2;
    }

    public String getCurrentScripName() {
        return this.strData[this.iCurrentIndex][0];
    }

    private void dispose() {
        AppConstants.bCommonCanvasThread = false;
        this.t = null;
    }

    public void paintScroller(Graphics g) {
    }
}

