/*
 * Decompiled with CFR 0.152.
 */
package connection;

import common.AppConstants;
import common.Profile;
import common.TagData;
import common.Utilities;
import connection.HTTPThread;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import market.iWinRefresh;
import structures.CMsgHeader;

public class SendRequest {
    private iWinRefresh iwinapp;
    private String strViewType = "MARKETWATCH";
    private final String strNameValueDlmter;
    private final byte TAGNO_MKTSEGID;
    private final byte TAGNO_SCREEN_WIDTH = (byte)2;
    private final byte TAGNO_SCREEN_HEIGHT = (byte)3;
    private final byte TAGNO_UNIFIEDID = (byte)5;
    private final byte TAGNO_FUND_NAME = (byte)13;
    private final byte TAGNO_SCHEME_NAME = (byte)14;
    private final byte TAGNO_PROFILE_DATA = (byte)28;
    private final byte TAGNO_INSTRUMENTID = (byte)29;
    private final byte TAGNO_SYMBOL = (byte)31;
    private final byte TAGNO_INST_TYPE = (byte)32;
    private final byte TAGNO_EXPIRY_DATE = (byte)33;
    private final byte TAGNO_STRIKE_PRICE = (byte)34;
    private final byte TAGNO_OPTION_TYPE = (byte)35;
    private final byte TAGNO_INSTRUMENTNAME = (byte)43;
    private final byte TAGNO_SCRIP_IDENTIFIER = (byte)45;
    private final byte TAGNO_USERID = (byte)67;
    private final byte TAGNO_PASSWORD = (byte)68;
    private final byte TAGNO_PROFILE_NAME = (byte)83;
    private final byte TAGNO_COUNTRY_NAME = (byte)91;
    private final byte TAGNO_FREQUENCY = (byte)92;
    private final byte TAGNO_EVENT_ID = (byte)95;
    private final int iUnifiedId;

    public SendRequest() {
        this.strNameValueDlmter = "=";
        this.TAGNO_MKTSEGID = 1;
        this.iUnifiedId = 1;
        this.iwinapp = iWinRefresh.getInstance();
    }

    public void sendBrokerImageRequest(String strBrokerId) {
        if (!strBrokerId.equals("")) {
            StringBuffer strRequetUrl = new StringBuffer();
            strRequetUrl.append(AppConstants.strWebServer).append("/").append(strBrokerId).append("/logo.png");
            HTTPThread httpthread = new HTTPThread(strRequetUrl.toString(), null, 2);
            Thread t = new Thread(httpthread);
            t.start();
        }
    }

    public void sendLoginRequest(String strpUserId, String strPassword) {
        StringBuffer strData = new StringBuffer();
        AppConstants.strUserId = strpUserId;
        strData.append("67=" + strpUserId.toUpperCase()).append("|");
        strData.append("68=" + strPassword).append("|");
        strData.append("45=3.8").append("|");
        strData.append("5=1");
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/CfrmLoginPage.aspx", strData, 4);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendParityCalcRequest() {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/Parity.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendPortfolioRequest() {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("5=1");
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/Portfolio.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendNewPortfolioRequest() {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("5=1");
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/PortfolioTransaction.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendAddRemovePMSRequest(String strpSegId, String strpInstId, String strpKey, String strpQty, String strpPrice, String strpAddRemoveTag) {
        AppConstants.bHTTPRequestSent = true;
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("5=1").append("|");
        strData.append("1=" + strpSegId).append("|");
        strData.append("29=" + strpInstId).append("|");
        strData.append("28=" + strpKey).append("|");
        strData.append("2=" + strpQty).append("|");
        strData.append("3=" + strpPrice).append("|");
        strData.append("45=" + strpAddRemoveTag);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/AddRemovePMS.aspx", strData);
        Utilities.printLog("ADD OR REMOVE PMS:" + strData.toString());
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendNewAddRemovePMSRequest(String strpSegId, String strpInstId, String strpKey, String strpQty, String strpPrice, String strpAddRemoveTag) {
        AppConstants.bHTTPRequestSent = true;
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("5=1").append("|");
        strData.append("1=" + strpSegId).append("|");
        strData.append("29=" + strpInstId).append("|");
        strData.append("28=" + strpKey).append("|");
        strData.append("2=" + strpQty).append("|");
        strData.append("3=" + strpPrice).append("|");
        strData.append("45=" + strpAddRemoveTag);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/AddRemovePMSTransaction.aspx", strData);
        Utilities.printLog("ADD OR REMOVE PMS:" + strData.toString());
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendNewsRequest() {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/Top10News.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendNewsStoryRequest(String strSerialNo) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + strSerialNo);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/NewsStory.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendScripWiseNewsRequest(String f_strkeyOfData) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("13=1").append("|");
        strData.append("28=" + f_strkeyOfData).append("|");
        strData.append("14=10");
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/ScripWiseNews.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendGainersLosersRequest(int ipMarketSegId, int ipInstId, String strpInstName, int iGainerLoserIndex) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + ipMarketSegId).append("|");
        strData.append("29=" + ipInstId).append("|");
        strData.append("43=" + strpInstName).append("|");
        strData.append("45=" + iGainerLoserIndex);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/GainersLosers.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendBSE30Request(String f_strRequestString) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + f_strRequestString, strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendChartRequest(String strpSegmentId, String strpInstId, String strpKey, int ipWidth, int ipHeight) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + strpSegmentId).append("|");
        strData.append("29=" + strpInstId).append("|");
        strData.append("45=" + strpKey).append("|");
        strData.append("2=" + ipWidth).append("|");
        strData.append("3=" + ipHeight);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/Charts.aspx", strData, 3);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendInteractiveChartRequest(String strpSegmentId, String strpInstId, String strpKey, int ipChartType) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + strpSegmentId).append("|");
        strData.append("29=" + strpInstId).append("|");
        strData.append("45=" + strpKey).append("|");
        strData.append("5=" + ipChartType);
        Utilities.printLog("INTERACTIVE:" + strData);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/IndicatorsNStudies.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendMarketWatchRequestRealtime() {
        AppConstants.iCurrentPage = (byte)5;
        if (AppConstants.BackFromExchange && !AppConstants.selectProfile) {
            AppConstants.BackFromExchange = false;
            int maxScript = iWinRefresh.getInstance().showform.marketwatch.getMaxScriptsPerPages();
            Profile profile = AppConstants.profilelist.getData(Integer.toString(AppConstants.SELECT_PROFILE_INDEX));
            TagData[] tag = profile.getTagData();
            int Countremove = tag.length - 1;
            int temp = Countremove - Countremove % maxScript;
            iWinRefresh.getInstance().showform.marketwatch.setCurrentIndex(temp);
            int iLength = tag.length;
            this.iwinapp.showform.marketwatch.Initialize(iLength, tag);
            this.startTouchlineRequest(temp, this.iwinapp.showform.marketwatch.iMaxScriptsPerPage, 0);
        } else {
            this.startTouchlineRequest(this.iwinapp.showform.marketwatch.iCurrentIndex, this.iwinapp.showform.marketwatch.iMaxScriptsPerPage, 0);
        }
        this.iwinapp.showform.showMarketWatch();
    }

    public void startTouchlineRequest(int iStartPage, int iLoopCounter, int iMarketOrBestFive) {
        Profile profile = AppConstants.profilelist.getData(Integer.toString(AppConstants.SELECT_PROFILE_INDEX));
        if (profile != null) {
            TagData[] tag = profile.getTagData();
            if (!AppConstants.bMarketWatchRequest && AppConstants.PERVIOUS_PAGE == 0) {
                AppConstants.STR_PROFILE_NAME = profile.getProfileName();
                AppConstants.bMarketWatchRequest = true;
                int iLength = tag.length;
                this.iwinapp.showform.marketwatch.Initialize(iLength, tag);
                this.startStopIndexRequest(0);
            }
            for (int i = iStartPage; i < iStartPage + iLoopCounter; ++i) {
                if (i >= tag.length) continue;
                if (AppConstants.profilelist.ifAlertExists(tag[i].strKeyOfData) || tag[i].strKeyOfData.equals("658:0") || tag[i].strKeyOfData.equals("3556:0") || tag[i].strKeyOfData.equals("4944:0")) {
                    this.sendRealtimeRequest(tag[i], 1, 0);
                }
                this.sendRealtimeRequest(tag[i], 0, iMarketOrBestFive);
            }
        }
    }

    public void stopTouchlineRequest(int iSartIndex, int iLoopCounter, int iMarketOrBestFive) {
        Profile profile = AppConstants.profilelist.getData(Integer.toString(AppConstants.SELECT_PROFILE_INDEX));
        if (profile != null) {
            TagData[] tag = profile.getTagData();
            for (int i = iSartIndex; i < iSartIndex + iLoopCounter; ++i) {
                if (i >= tag.length || AppConstants.profilelist.ifAlertExists(tag[i].strKeyOfData) || tag[i].strKeyOfData.equals("658:0") || tag[i].strKeyOfData.equals("3556:0") || tag[i].strKeyOfData.equals("4944:0")) continue;
                this.sendRealtimeRequest(tag[i], 1, iMarketOrBestFive);
            }
        }
    }

    public void startStopIndexRequest(int iStartOrStop) {
        if (AppConstants.SELECT_PROFILE_INDEX > 0) {
            int i = 0;
            TagData tagdata = null;
            if (AppConstants.bMCXSXIndex) {
                tagdata = new TagData();
                tagdata.ExtractData("34", "-3", "12674:0^0^SX40");
                this.iwinapp.showform.marketwatch.setIndexKey(i, tagdata);
                this.sendStartStopIndexRequest(iStartOrStop, tagdata);
                ++i;
            }
            if (AppConstants.bNSEIndex) {
                tagdata = new TagData();
                tagdata.ExtractData("4", "-1", "3556:0^0^NFY");
                this.iwinapp.showform.marketwatch.setIndexKey(i, tagdata);
                this.sendStartStopIndexRequest(iStartOrStop, tagdata);
                ++i;
            }
            if (AppConstants.bMCXIndex && i < 2) {
                tagdata = new TagData();
                tagdata.ExtractData("2", "-1", "4944:0^0^MCXCOM");
                this.iwinapp.showform.marketwatch.setIndexKey(i, tagdata);
                this.sendStartStopIndexRequest(iStartOrStop, tagdata);
                ++i;
            }
            if (AppConstants.bBSEIndex && i < 2) {
                tagdata = new TagData();
                tagdata.ExtractData("3", "-1", "658:0^0^SNX");
                this.iwinapp.showform.marketwatch.setIndexKey(i, tagdata);
                this.sendStartStopIndexRequest(iStartOrStop, tagdata);
                ++i;
            }
        }
    }

    private void sendStartStopIndexRequest(int ipStartorStop, TagData f_ObjtagData) {
        if (ipStartorStop == 0) {
            if (AppConstants.profilelist.ifAlertExists(f_ObjtagData.strKeyOfData)) {
                this.sendRealtimeRequest(f_ObjtagData, 1, 0);
            }
            this.sendRealtimeRequest(f_ObjtagData, 0, 0);
        } else if (!AppConstants.profilelist.ifAlertExists(f_ObjtagData.strKeyOfData)) {
            this.sendRealtimeRequest(f_ObjtagData, 1, 0);
        }
    }

    public void startStopAlertRequest(int iStartOrStop) {
        TagData[] tag = AppConstants.profilelist.getAlertsProfile();
        for (int i = 0; i < tag.length; ++i) {
            this.sendRealtimeRequest(tag[i], iStartOrStop, 0);
        }
    }

    public void startStopParityRequest(TagData[] f_tagBaseContract, TagData[] f_tagFutureContract, TagData f_tagUSDINR, int iStartOrStop, int iCounter) {
        if (f_tagUSDINR.iSegmentId != 0) {
            this.sendRealtimeRequest(f_tagUSDINR, iStartOrStop, 0);
        }
        for (int i = 0; i < iCounter; ++i) {
            this.sendRealtimeRequest(f_tagFutureContract[i], iStartOrStop, 0);
            this.sendRealtimeRequest(f_tagBaseContract[i], iStartOrStop, 0);
        }
    }

    public void sendIPOMutualFundRequest(int ipIndex, int ipPageNo, String strpFundName, String strpSchemeName) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + ipIndex).append("|");
        strData.append("39=" + ipPageNo).append("|");
        strData.append("13=" + strpFundName).append("|");
        strData.append("14=" + strpSchemeName);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + AppConstants.strRequestString, strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendIndexRequest(int ipSegment) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + ipSegment);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/Index.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendAddScripRequest(int ipMarketSegmentId, int ipInstrumentId, String strProfileName, String strpProfileData) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("45=" + this.strViewType).append("|");
        strData.append("83=" + strProfileName).append("|");
        strData.append("5=1").append("|");
        strData.append("1=" + ipMarketSegmentId + "|");
        strData.append("29=" + ipInstrumentId + "|");
        strData.append("28=" + strpProfileData);
        System.out.println("Adding scrip request" + strData);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/CfrmAddScripPage.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendAddOrRemoveAlertRequest(int ipMktSegId, int ipInstId, String strpProfileData, int iEntity, int iPrice, int iPageName) {
        AppConstants.bHTTPRequestSent = true;
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("5=1").append("|");
        strData.append("1=" + ipMktSegId).append("|");
        strData.append("29=" + ipInstId).append("|");
        strData.append("28=" + strpProfileData).append("|");
        strData.append("2=" + iEntity).append("|");
        strData.append("3=" + iPrice).append("|");
        strData.append("45=" + iPageName);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/AddAlert.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendSaveRequest(String strpProfileName, String strpProfileData) {
        AppConstants.bHTTPRequestSent = true;
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("45=" + this.strViewType).append("|");
        strData.append("83=" + strpProfileName).append("|");
        strData.append("5=1").append("|");
        strData.append("28=" + strpProfileData);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/SaveProfile.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendSymbolLookupRequest(int iMarketSegmentId, int iInstrumentId, String strInstrumentName, int iPageNo, String strName, String strExpiryDate, String strStrikePrice, String strOptionType, String strInstType, int f_nContractType) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + iMarketSegmentId).append("|");
        strData.append("29=" + iInstrumentId).append("|");
        strData.append("43=" + strInstrumentName).append("|");
        strData.append("31=" + strName + "|");
        strData.append("32=" + strInstType + "|");
        strData.append("33=" + strExpiryDate + "|");
        strData.append("34=" + strStrikePrice + "|");
        strData.append("35=" + strOptionType + "|");
        strData.append("39=" + Integer.toString(iPageNo) + "|");
        strData.append("45=" + Integer.toString(f_nContractType));
        Utilities.printLog(strData.toString());
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/SymbolLookup.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendEconSymbolLookupRequest(String strCountryName, String strFrequency, int iPageNo) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("91=" + strCountryName).append("|");
        strData.append("92=" + strFrequency).append("|");
        strData.append("39=" + Integer.toString(iPageNo));
        Utilities.printLog(strData.toString());
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/EconomicCalendar.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendEconomicDetailRequest(String strEventId) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("91=" + AppConstants.strCountryId).append("|");
        strData.append("95=" + strEventId);
        Utilities.printLog(strData.toString());
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/EconomicCalendarDetails.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendWorldIndicesRequest(int ipIndex, int ipPage) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + ipIndex).append("|");
        strData.append("39=" + ipPage);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/WorldIndices.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendRemoveScripRequest(String strpMarketSegmentId, String strpInstrumentId, String strpProfileName, String strpProfileData) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("45=" + this.strViewType + "|");
        strData.append("83=" + strpProfileName + "|");
        strData.append("5=1").append("|");
        strData.append("1=" + strpMarketSegmentId).append("|");
        strData.append("29=" + strpInstrumentId).append("|");
        strData.append("28=" + strpProfileData);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/CfrmRemoveScripPage.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendGetProfiles() {
        AppConstants.bHTTPRequestSent = true;
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("5=1");
        Utilities.printLog("sendGetProfiles:");
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/CfrmGetProfiles.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendDefaultProfileRequest(int ipProfileId, String strpViewType) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + ipProfileId).append("|");
        strData.append("5=1").append("|");
        strData.append("83=" + strpViewType);
        Utilities.printLog("sendDefaultProfileRequest");
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/CfrmDefaultProfile.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    public void sendDeleteProfileRequest(int ipProfileId, String strpViewType) {
        StringBuffer strData = new StringBuffer();
        strData.append("67=" + AppConstants.strUserId).append("|");
        strData.append("4=" + AppConstants.strSessionId).append("|");
        strData.append("1=" + ipProfileId).append("|");
        strData.append("5=1").append("|");
        strData.append("83=" + strpViewType);
        HTTPThread httpthread = new HTTPThread(AppConstants.strWebServer + "/CfrmDeleteProfile.aspx", strData);
        Thread t = new Thread(httpthread);
        t.start();
    }

    private byte[] FormatHeader(TagData tagdata, int iAddDelete, int iMarketOrBestFive) {
        CMsgHeader l_objMsgHeader = new CMsgHeader();
        try {
            l_objMsgHeader.m_nSegmentId = tagdata.iSegmentId;
            l_objMsgHeader.m_nInstrumentType = tagdata.iInstrumentId == -1 || tagdata.iInstrumentId == -3 ? tagdata.iInstrumentId * -1 : tagdata.iInstrumentId;
            l_objMsgHeader.m_nMsgLength = 34;
            l_objMsgHeader.m_nMsgTimeStamp = 0;
            l_objMsgHeader.m_nMsgCategory = 1;
            block1 : switch (tagdata.iSegmentId) {
                case 3: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10086;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10087;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10008 : 10009;
                                }
                            }
                            break;
                        }
                        case -1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 40000 : 40001;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10010;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10011;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10010 : 10011;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10012;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10013;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10012 : 10013;
                                }
                            }
                            break;
                        }
                        case 4: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10126;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10127;
                            break;
                        }
                        case -1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 40002 : 40003;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10102;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10103;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10016 : 10017;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10014;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10015;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10014 : 10015;
                                }
                            }
                            break;
                        }
                        case -1: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 40006;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 40007;
                            break;
                        }
                        case -2: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 40004 : 40005;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10027;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10028;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10027 : 10028;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10029;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10030;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10029 : 10030;
                                }
                            }
                            break;
                        }
                        case -1: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 40010;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 40011;
                            break;
                        }
                        case -2: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 40008 : 40009;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (iMarketOrBestFive) {
                        case 0: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10282;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10283;
                            break;
                        }
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10280 : 10281;
                        }
                    }
                    break;
                }
                case 34: {
                    block82 : switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10090;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10091;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10070 : 10071;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10130;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10131;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10128 : 10129;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10274;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10275;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10272 : 10273;
                                }
                            }
                            break;
                        }
                        case -3: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 40026;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 40027;
                            break;
                        }
                        case 4: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10278;
                                        break block82;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10279;
                                    break block82;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10276 : 10277;
                                }
                            }
                        }
                    }
                    break;
                }
                case 35: {
                    block105 : switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10092;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10093;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10076 : 10077;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10134;
                                        break block105;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10135;
                                    break block105;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10132 : 10133;
                                }
                            }
                        }
                    }
                    break;
                }
                case 12: {
                    switch (tagdata.iInstrumentId) {
                        case 2: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10034;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10035;
                            break;
                        }
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10032 : 10033;
                        }
                    }
                    break;
                }
                case 13: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10036 : 10037;
                        }
                    }
                    break;
                }
                case 17: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10038;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10039;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10038 : 10039;
                                }
                            }
                            break;
                        }
                        case 3: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10074;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10075;
                            break;
                        }
                        case 2: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10066 : 10067;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10242 : 10243;
                        }
                    }
                    break;
                }
                case 7: {
                    block136 : switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10116;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10117;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10023 : 10024;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10118;
                                        break;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10119;
                                    break;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10040 : 10041;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10120;
                                        break block136;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10121;
                                    break block136;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10064 : 10065;
                                }
                            }
                        }
                    }
                    break;
                }
                case 8: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10244 : 10245;
                        }
                    }
                    break;
                }
                case 45: {
                    block156 : switch (tagdata.iInstrumentId) {
                        case 1: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10140;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10141;
                            break;
                        }
                        case 2: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10192;
                                        break block156;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10193;
                                    break block156;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10190 : 10191;
                                }
                            }
                        }
                    }
                    break;
                }
                case 46: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10142;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10143;
                            break;
                        }
                        case 2: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10144;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10145;
                            break;
                        }
                        case 3: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10214;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10215;
                            break;
                        }
                        case 4: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10216 : 10217;
                        }
                    }
                    break;
                }
                case 48: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10148;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10149;
                            break;
                        }
                        case 2: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10150 : 10151;
                        }
                    }
                    break;
                }
                case 49: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10152;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10153;
                            break;
                        }
                        case 2: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10154 : 10155;
                        }
                    }
                    break;
                }
                case 50: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10156;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10157;
                            break;
                        }
                        case 2: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10158;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10159;
                            break;
                        }
                        case 3: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10160;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10161;
                            break;
                        }
                        case 4: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10162 : 10163;
                        }
                    }
                    break;
                }
                case 52: {
                    switch (iMarketOrBestFive) {
                        case 0: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10204;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10205;
                            break;
                        }
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10202 : 10203;
                        }
                    }
                    break;
                }
                case 53: {
                    switch (iMarketOrBestFive) {
                        case 0: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10200;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10201;
                            break;
                        }
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10198 : 10199;
                        }
                    }
                    break;
                }
                case 54: {
                    switch (iMarketOrBestFive) {
                        case 0: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10196;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10197;
                            break;
                        }
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10194 : 10195;
                        }
                    }
                    break;
                }
                case 55: {
                    switch (iMarketOrBestFive) {
                        case 0: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10208;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10209;
                            break;
                        }
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10206 : 10207;
                        }
                    }
                    break;
                }
                case 56: {
                    switch (iMarketOrBestFive) {
                        case 0: {
                            if (iAddDelete == 0) {
                                l_objMsgHeader.m_nMsgCode = 10212;
                                break;
                            }
                            l_objMsgHeader.m_nMsgCode = 10213;
                            break;
                        }
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10210 : 10211;
                        }
                    }
                    break;
                }
                case 57: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10254 : 10255;
                        }
                    }
                    break;
                }
                case 60: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            switch (iMarketOrBestFive) {
                                case 0: {
                                    if (iAddDelete == 0) {
                                        l_objMsgHeader.m_nMsgCode = 10270;
                                        break block1;
                                    }
                                    l_objMsgHeader.m_nMsgCode = 10271;
                                    break block1;
                                }
                                case 1: {
                                    l_objMsgHeader.m_nMsgCode = iAddDelete == 0 ? 10268 : 10269;
                                }
                            }
                        }
                    }
                }
            }
            return l_objMsgHeader.ToByteArray();
        }
        catch (Exception e) {
            Utilities.printLog("FormatHeader " + e.toString());
            return null;
        }
    }

    private byte[] FormatTailer(TagData tagdata) throws IOException {
        byte[] bytedata = null;
        try {
            ByteArrayOutputStream l_objByteArrayInputStream = new ByteArrayOutputStream();
            DataOutputStream l_objDataInputStream = new DataOutputStream(l_objByteArrayInputStream);
            byte[] btInstrumentName = new byte[7];
            byte[] btOptionType = new byte[3];
            byte[] btMarketType = new byte[1];
            byte[] btSymbol = new byte[11];
            byte[] btSeries = new byte[3];
            byte[] btUniqueidentifier = new byte[64];
            l_objDataInputStream.writeShort(0);
            l_objDataInputStream.writeInt(1);
            switch (tagdata.iSegmentId) {
                case 2: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            l_objDataInputStream.writeInt(tagdata.iIdentifierOfUnderlying);
                            btOptionType = new byte[3];
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                            break;
                        }
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            l_objDataInputStream.writeInt(tagdata.iIdentifierOfUnderlying);
                            break;
                        }
                        case -1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            break;
                        }
                        case -2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            break;
                        }
                        case -1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            System.arraycopy(tagdata.strSeries.getBytes(), 0, btSeries, 0, tagdata.strSeries.getBytes().length);
                            l_objDataInputStream.write(btSeries);
                            System.arraycopy(tagdata.strMarketType.getBytes(), 0, btMarketType, 0, tagdata.strMarketType.getBytes().length);
                            l_objDataInputStream.write(btMarketType);
                            break;
                        }
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            System.arraycopy(tagdata.strInstrumentName.getBytes(), 0, btInstrumentName, 0, tagdata.strInstrumentName.getBytes().length);
                            l_objDataInputStream.write(btInstrumentName);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            System.arraycopy(tagdata.strMarketType.getBytes(), 0, btMarketType, 0, tagdata.strMarketType.getBytes().length);
                            l_objDataInputStream.write(btMarketType);
                            break;
                        }
                        case 4: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[26];
                            String strSymbol = tagdata.strSymbol.replace('#', '^');
                            System.arraycopy(strSymbol.getBytes(), 0, btSymbol, 0, strSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                            break;
                        }
                        case -1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                        }
                    }
                    break;
                }
                case 9: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btInstrumentName = new byte[7];
                            System.arraycopy(tagdata.strInstrumentName.getBytes(), 0, btInstrumentName, 0, tagdata.strInstrumentName.getBytes().length);
                            l_objDataInputStream.write(btInstrumentName);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                            btOptionType = new byte[3];
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            btMarketType = new byte[1];
                            System.arraycopy(tagdata.strMarketType.getBytes(), 0, btMarketType, 0, tagdata.strMarketType.getBytes().length);
                            l_objDataInputStream.write(btMarketType);
                            btSymbol = new byte[11];
                            System.arraycopy(tagdata.strSymbol.getBytes(), 0, btSymbol, 0, tagdata.strSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                            break;
                        }
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[11];
                            System.arraycopy(tagdata.strSymbol.getBytes(), 0, btSymbol, 0, tagdata.strSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                            break;
                        }
                        case -1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            break;
                        }
                        case -2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                        }
                    }
                    break;
                }
                case 10: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            l_objDataInputStream.writeInt(tagdata.iIdentifierOfUnderlying);
                            btOptionType = new byte[3];
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                            break;
                        }
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btUniqueidentifier = new byte[65];
                            System.arraycopy(tagdata.strUniqueIdentifier.getBytes(), 0, btUniqueidentifier, 0, tagdata.strUniqueIdentifier.getBytes().length);
                            l_objDataInputStream.write(btUniqueidentifier);
                            btSymbol = new byte[33];
                            String[] strSym = new String[2];
                            strSym = Utilities.split(tagdata.strUniqueIdentifier, "-");
                            System.arraycopy(strSym[0].getBytes(), 0, btSymbol, 0, strSym[0].getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 52: 
                case 55: 
                case 56: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            l_objDataInputStream.writeInt(tagdata.iIdentifierOfUnderlying);
                            btOptionType = new byte[3];
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                        }
                    }
                    break;
                }
                case 34: {
                    switch (tagdata.iInstrumentId) {
                        case 1: 
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            l_objDataInputStream.writeInt(tagdata.iIdentifierOfUnderlying);
                            btOptionType = new byte[3];
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                            break;
                        }
                        case 3: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            int l_nMarketType = Integer.parseInt(tagdata.strMarketType);
                            l_objDataInputStream.writeShort(l_nMarketType);
                            btSeries = new byte[3];
                            System.arraycopy(tagdata.strSeries.getBytes(), 0, btSeries, 0, tagdata.strSeries.getBytes().length);
                            l_objDataInputStream.write(btSeries);
                            break;
                        }
                        case -3: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            break;
                        }
                        case 4: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            l_objDataInputStream.writeInt(tagdata.iIdentifierOfUnderlying);
                            btOptionType = new byte[3];
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                        }
                    }
                    break;
                }
                case 35: {
                    switch (tagdata.iInstrumentId) {
                        case 1: 
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            System.arraycopy(tagdata.strInstrumentName.getBytes(), 0, btInstrumentName, 0, tagdata.strInstrumentName.getBytes().length);
                            l_objDataInputStream.write(btInstrumentName);
                            l_objDataInputStream.writeInt(tagdata.iExpiryDate);
                            l_objDataInputStream.writeInt(tagdata.iStrikePrice);
                            System.arraycopy(tagdata.strOptionType.getBytes(), 0, btOptionType, 0, tagdata.strOptionType.getBytes().length);
                            l_objDataInputStream.write(btOptionType);
                            System.arraycopy(tagdata.strMarketType.getBytes(), 0, btMarketType, 0, tagdata.strMarketType.getBytes().length);
                            l_objDataInputStream.write(btMarketType);
                        }
                    }
                    break;
                }
                case 17: {
                    switch (tagdata.iInstrumentId) {
                        case 1: 
                        case 2: 
                        case 3: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[41];
                            System.arraycopy(tagdata.strSymbol.getBytes(), 0, btSymbol, 0, tagdata.strSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 5: 
                case 8: 
                case 45: 
                case 57: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 7: {
                    switch (tagdata.iInstrumentId) {
                        case 1: 
                        case 2: 
                        case 3: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 13: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 12: {
                    switch (tagdata.iInstrumentId) {
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                            break;
                        }
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strSymbol = tagdata.strSymbol.replace('#', ':');
                            strSymbol = strSymbol.replace('*', '\\');
                            System.arraycopy(strSymbol.getBytes(), 0, btSymbol, 0, strSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 46: 
                case 48: {
                    switch (tagdata.iInstrumentId) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 49: {
                    switch (tagdata.iInstrumentId) {
                        case 1: 
                        case 2: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 50: {
                    switch (tagdata.iInstrumentId) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 53: {
                    break;
                }
                case 54: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            btSymbol = new byte[21];
                            String strExchangeSymbol = tagdata.strSymbol.replace('#', ':');
                            strExchangeSymbol = strExchangeSymbol.replace('*', '\\');
                            System.arraycopy(strExchangeSymbol.getBytes(), 0, btSymbol, 0, strExchangeSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                    break;
                }
                case 60: {
                    switch (tagdata.iInstrumentId) {
                        case 1: {
                            l_objDataInputStream.writeInt(tagdata.iFTCode);
                            byte[] btUniqueIdentifier = new byte[31];
                            if (tagdata.strUniqueIdentifier.indexOf(43) > 0) {
                                tagdata.strUniqueIdentifier = tagdata.strUniqueIdentifier.replace('+', '_');
                            }
                            System.arraycopy(tagdata.strUniqueIdentifier.getBytes(), 0, btUniqueIdentifier, 0, tagdata.strUniqueIdentifier.getBytes().length);
                            l_objDataInputStream.write(btUniqueIdentifier);
                            btSymbol = new byte[31];
                            System.arraycopy(tagdata.strSymbol.getBytes(), 0, btSymbol, 0, tagdata.strSymbol.getBytes().length);
                            l_objDataInputStream.write(btSymbol);
                        }
                    }
                }
            }
            l_objDataInputStream.close();
            bytedata = l_objByteArrayInputStream.toByteArray();
        }
        catch (Exception e) {
            Utilities.printLog("FormatTrailer " + e.toString());
            bytedata = null;
        }
        return bytedata;
    }

    private void FormatData(byte[] pbtHeader, byte[] pbtTailer) {
        byte[] btSendData = new byte[pbtHeader.length + pbtTailer.length];
        System.arraycopy(pbtHeader, 0, btSendData, 0, pbtHeader.length);
        System.arraycopy(pbtTailer, 0, btSendData, pbtHeader.length, pbtTailer.length);
        AppConstants.cInfofeedmain.m_objServerConnector.SendMessage(btSendData);
    }

    public void sendRealtimeRequest(TagData tag, int iStartOrStop, int iMarketOrBestFive) {
        try {
            byte[] btHeader = this.FormatHeader(tag, iStartOrStop, iMarketOrBestFive);
            byte[] btdata = this.FormatTailer(tag);
            this.FormatData(btHeader, btdata);
        }
        catch (Exception e) {
            Utilities.printLog("RealTimeRequest " + tag.strScripDesc + " " + e.toString());
        }
    }
}

