/*
 * Decompiled with CFR 0.152.
 */
package connection;

import chart.ChartCanvas;
import common.AppConstants;
import common.DynamicExchange;
import common.ParityCalc;
import common.Profile;
import common.TagData;
import common.Utilities;
import market.iWinRefresh;

public class ProcessResponse {
    private iWinRefresh iwinapp;
    private final String strDollarDlmter;
    private final String strAndDlmter;
    private final String strCapDlmter;
    private final byte PORTFOLIO_RESPONSE = (byte)40;
    private final byte ADD_REMOVE_ALERT_RESPONSE = (byte)41;
    private final byte ADD_REMOVE_PMS_RESPONSE = (byte)42;
    private final byte SAVE_PROFILE_RESPONSE = (byte)43;
    private final byte PROFILE_RESPONSE = (byte)44;
    private final byte DELETE_PROFILE_RESPONSE = (byte)45;
    private final byte DEFAULT_PROFILE_RESPONSE = (byte)46;
    private final byte MESSAGE_DETAILS_RESPONSE = (byte)47;
    private final byte INSURANCE_RESPONSE = (byte)48;
    private final byte WORLD_INDICES_RESPONSE = (byte)49;
    private final byte LOGON_RESPONSE = (byte)102;
    private final byte PARITY_CALC_RESPONSE = (byte)103;
    private final byte NEWS_RESPONSE = (byte)104;
    private final byte NEWS_STORY_RESPONSE = (byte)105;
    private final byte INTERACTIVE_CHARTS_RESPONSE = (byte)106;
    private final byte IPO_RESPONSE = (byte)112;
    private final byte MUTUAL_FUND_RESPONSE = (byte)114;
    private final byte SYMBOL_LOOKUP_RESPONSE = (byte)126;
    private final int GAINERS_LOSERS_RESPONSE;
    private final int TOPPERS_SHOCKERS_RESPONSE;
    private final int BSE30_RESPONSE;
    private final int NIFTY50_RESPONSE;
    private final int INDEX_RESPONSE;
    private final int REMOVE_SCRIP_RESPONSE;
    private final int ADD_SCRIP_RESPONSE;
    private final int SESSION_EXPIRED_RESPONSE;
    private final int ECONOMIC_DATA_RESPONSE;
    private final int ECONOMIC_DETAIL_RESPONSE;
    private final byte TAGNO_ERRSTRING = (byte)19;
    private final byte TAGNO_ITEM_COUNT = (byte)36;
    private final byte TAGNO_SYMBOL_LOOKUP_TOTAL_PAGES = (byte)40;
    private final byte TAGNO_DETAIL = (byte)19;
    private final byte TAGNO_LOGONSTATUS = (byte)70;
    private final int TAGNO_BROKER_ID;
    private final int TAGNO_NEWS_HEADING;
    private final int TAGNO_INSTRUMENT_ALLOWED;
    private final byte SEGMENT_INSURANCE = (byte)43;
    private final byte SEGMENT_NEWS = (byte)11;
    private final byte SEGMENT_PREMIUM_FEATURES = (byte)19;
    private final byte SEGMENT_MUTUALFUND = (byte)28;
    private final byte SEGMENT_ECONOMIC_FEATURE = (byte)38;

    public ProcessResponse() {
        this.strDollarDlmter = "$";
        this.strAndDlmter = "&";
        this.strCapDlmter = "^";
        this.GAINERS_LOSERS_RESPONSE = 132;
        this.TOPPERS_SHOCKERS_RESPONSE = 133;
        this.BSE30_RESPONSE = 218;
        this.NIFTY50_RESPONSE = 219;
        this.INDEX_RESPONSE = 225;
        this.REMOVE_SCRIP_RESPONSE = 300;
        this.ADD_SCRIP_RESPONSE = 301;
        this.SESSION_EXPIRED_RESPONSE = 305;
        this.ECONOMIC_DATA_RESPONSE = 226;
        this.ECONOMIC_DETAIL_RESPONSE = 227;
        this.TAGNO_BROKER_ID = 313;
        this.TAGNO_NEWS_HEADING = 327;
        this.TAGNO_INSTRUMENT_ALLOWED = 401;
        this.iwinapp = iWinRefresh.getInstance();
    }

    public void ProcessHTTPResponse(StringBuffer strbuffResponse) {
        String strResponse = strbuffResponse.toString().trim();
        Utilities.printLog("ProcessHTTPResponse " + strResponse);
        int iMessageCode = 0;
        try {
            String strMessageCode = this.getHeaderValue(strResponse);
            if (strMessageCode.equals("") || strMessageCode.equals("0")) {
                this.iwinapp.progress.stopProgress();
                this.processErrorResponse(strResponse, true);
                return;
            }
            if (!AppConstants.bHTTPRequestSent) {
                return;
            }
            AppConstants.bHTTPRequestSent = false;
            iMessageCode = Integer.parseInt(strMessageCode);
            switch (iMessageCode) {
                case 102: {
                    this.processLogonResponse(strResponse);
                    break;
                }
                case 44: {
                    this.iwinapp.progress.setProgress("Login Successful", 4);
                    this.processProfileNames(strResponse);
                    AppConstants.sendrequest.sendBrokerImageRequest(AppConstants.strBrokerId);
                    this.iwinapp.progress.stopProgress();
                    AppConstants.bLoggedIn = true;
                    if (AppConstants.bLoggedIn) {
                        Thread.sleep(500L);
                        AppConstants.cInfofeedmain.startThread();
                        AppConstants.sendrequest.startStopAlertRequest(0);
                        this.iwinapp.showform.showMainMenu();
                    }
                    break;
                }
                case 126: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processSymbolLookupResponse(strResponse);
                    break;
                }
                case 43: 
                case 45: 
                case 46: {
                    this.iwinapp.progress.stopProgress();
                    this.processDeleteDefaultProfileResponse(strResponse, iMessageCode);
                    this.iwinapp.showform.showMainMenu();
                    break;
                }
                case 49: 
                case 132: 
                case 133: 
                case 218: 
                case 219: 
                case 225: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processMarketInfoResponse(strResponse);
                    break;
                }
                case 300: {
                    this.iwinapp.progress.stopProgress();
                    this.processRemoveScripResponse(strResponse);
                    this.iwinapp.backForm(iWinRefresh.iPreviousForm);
                    break;
                }
                case 301: {
                    this.iwinapp.progress.stopProgress();
                    this.processAddScripResponse(strResponse);
                    this.iwinapp.backForm(iWinRefresh.iPreviousForm);
                    break;
                }
                case 40: 
                case 42: {
                    this.iwinapp.progress.stopProgress();
                    this.processPMSResponse(strResponse, iMessageCode);
                    break;
                }
                case 41: {
                    this.iwinapp.progress.stopProgress();
                    this.processAddAlertResponse(strResponse);
                    break;
                }
                case 104: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processNewsResponse(strResponse);
                    break;
                }
                case 226: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processEconomicDataResponse(strResponse);
                    break;
                }
                case 227: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processEconomicDetailResponse(strResponse);
                    break;
                }
                case 105: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processNewsStoryResponse(strResponse);
                    break;
                }
                case 112: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processIPOResponse(strResponse);
                    break;
                }
                case 114: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processMutualFundResponse(strResponse);
                    break;
                }
                case 48: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processInsuranceResponse(strResponse);
                    break;
                }
                case 103: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processParityCalcResponse(strResponse);
                    break;
                }
                case 106: {
                    this.iwinapp.progress.setProgress("Completed", 4);
                    this.iwinapp.progress.stopProgress();
                    this.processInteractiveChartResponse(strResponse);
                    break;
                }
                case 19: {
                    AppConstants.bCHARTS = true;
                    break;
                }
                default: {
                    this.iwinapp.progress.stopProgress();
                    this.processSessionExpiredResponse(strResponse);
                    this.iwinapp.assignNull();
                    this.iwinapp.quit();
                    break;
                }
            }
        }
        catch (Exception e) {
            Utilities.printLog("MAIN PROCESS RESPONSE=================================" + e.toString());
            this.processErrorResponse("MessageCode " + iMessageCode + " Error " + e.toString(), true);
        }
    }

    private void processLogonResponse(String strResponseString) {
        int VAL_LOGON_SUCCESS = 0;
        boolean VAL_LOGON_FAILED = true;
        String[] strResponse = Utilities.split(strResponseString, "|");
        AppConstants.strSessionId = this.FindValue(strResponse, Integer.toString(4)).trim();
        String strLogonMessage = this.FindValue(strResponse, Integer.toString(19)).trim();
        int iLogonStatus = Integer.parseInt(this.FindValue(strResponse, Integer.toString(70)).trim());
        if (iLogonStatus == VAL_LOGON_SUCCESS) {
            if (!strLogonMessage.equals("")) {
                iWinRefresh.displayAlert("MVMG", strLogonMessage, AppConstants.iAlertDisplayTime);
            }
            String strPriceWidth = "99999.99";
            AppConstants.strBrokerId = this.FindValue(strResponse, Integer.toString(313)).trim();
            String strInstrumentAllowed = this.FindValue(strResponse, Integer.toString(401)).trim();
            String[] strIntAllowed = Utilities.split(strInstrumentAllowed, "$");
            block31: for (int i = 0; i < strIntAllowed.length; ++i) {
                String[] strTemp = Utilities.split(strIntAllowed[i], ":");
                switch (Integer.parseInt(strTemp[0])) {
                    case 3: {
                        if (Integer.parseInt(strTemp[1]) != 1) continue block31;
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("BSE", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        dynamicExchange.putInstruments("EQUITY", strTemp[1]);
                        dynamicExchange.putInstruments("INDEX", "-1");
                        AppConstants.dynamicList.addExchange("BSE", dynamicExchange);
                        AppConstants.bBSEIndex = true;
                        continue block31;
                    }
                    case 4: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("NSE", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("EQUITY", strTemp[1]);
                            dynamicExchange.putInstruments("INDEX", "-1");
                            AppConstants.bNSEIndex = true;
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("FUTIDX", strTemp[1]);
                            dynamicExchange.putInstruments("FUTSTK", strTemp[1]);
                            dynamicExchange.putInstruments("OPTIDX", strTemp[1]);
                            dynamicExchange.putInstruments("OPTSTK", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 4) {
                            dynamicExchange.putInstruments("WDM", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("NSE", dynamicExchange);
                        continue block31;
                    }
                    case 2: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("MCX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("FUTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("INDEX", "-1");
                            AppConstants.bMCXIndex = true;
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("COM", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("MCX", dynamicExchange);
                        continue block31;
                    }
                    case 5: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("COMEX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            AppConstants.dynamicList.addExchange("COMEX", dynamicExchange);
                            AppConstants.bCOMEX = true;
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 8: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("NYMEX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            AppConstants.dynamicList.addExchange("NYMEX", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 7: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("LME", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("METAL", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 3) {
                            dynamicExchange.putInstruments("STEEL", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("LME", dynamicExchange);
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 9: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("NCDEX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("FUTCOM", strTemp[1]);
                            AppConstants.bNCDEXIndex = true;
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("COMDTY", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("NCDEX", dynamicExchange);
                        continue block31;
                    }
                    case 13: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("INTL", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("SPOT", strTemp[1]);
                            AppConstants.dynamicList.addExchange("INTL", dynamicExchange);
                            AppConstants.bINTLSPOT = true;
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 12: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("INTL FOREX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("SPOT", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("FORWARD", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("INTL FOREX", dynamicExchange);
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 17: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("FOREX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("SPOT", strTemp[1]);
                            AppConstants.bTPCONTRIBUTOR = true;
                        } else if (Integer.parseInt(strTemp[1]) == 3) {
                            dynamicExchange.putInstruments("SPOT CROSS", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("FORWARD", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("FOREX", dynamicExchange);
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 34: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("MCXSX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("FUTCUR", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCUR", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("FUTIRD", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 3) {
                            dynamicExchange.putInstruments("EQUITY", strTemp[1]);
                            dynamicExchange.putInstruments("INDEX", "-3");
                            AppConstants.bMCXSXIndex = true;
                        } else if (Integer.parseInt(strTemp[1]) == 4) {
                            dynamicExchange.putInstruments("FUTSTK", strTemp[1]);
                            dynamicExchange.putInstruments("OPTSTK", strTemp[1]);
                            dynamicExchange.putInstruments("FUTIDX", strTemp[1]);
                            dynamicExchange.putInstruments("OPTIDX", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("MCXSX", dynamicExchange);
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 35: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("NSE-CUR", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("FUTCUR", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCUR", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("FUTIRD", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("NSE-CUR", dynamicExchange);
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 45: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("SGX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("SGX", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 46: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("ICE_US_FX_IDX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("ICE_US_FX_IDX", dynamicExchange);
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("ICE_US_COMDTY", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("ICE_US_COMDTY", dynamicExchange);
                        } else if (Integer.parseInt(strTemp[1]) == 3) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("ICE_EU_FX_IDX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("ICE_EU_FX_IDX", dynamicExchange);
                        } else if (Integer.parseInt(strTemp[1]) == 4) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("ICE_EU_COMDTY", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("ICE_EU_COMDTY", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 48: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("CBOT_FX_IDX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("CBOT_FX_IDX", dynamicExchange);
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("CBOT_COMDTY", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("CBOT_COMDTY", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 49: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("CME-CUR", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("CME-CUR", dynamicExchange);
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("CME-IRD", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("CME-IRD", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 50: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("BURSA MALAYSIA", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("COM-FAO", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange.putInstruments("COM-SPREAD", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 3) {
                            dynamicExchange.putInstruments("FIN-FAO", strTemp[1]);
                        } else if (Integer.parseInt(strTemp[1]) == 4) {
                            dynamicExchange.putInstruments("FIN-SPREAD", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("BURSA MALAYSIA", dynamicExchange);
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 10: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 2) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("DGCX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURES", strTemp[1]);
                            dynamicExchange.putInstruments("SPREAD", strTemp[1]);
                            AppConstants.dynamicList.addExchange("DGCX", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 52: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("SMX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("COM", strTemp[1]);
                            dynamicExchange.putInstruments("FUTCUR", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCUR", strTemp[1]);
                            AppConstants.dynamicList.addExchange("SMX", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 54: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("LIFFE", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCOM", strTemp[1]);
                            AppConstants.dynamicList.addExchange("LIFFE", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 55: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("GBOT", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("COM", strTemp[1]);
                            dynamicExchange.putInstruments("FUTCUR", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCUR", strTemp[1]);
                            AppConstants.dynamicList.addExchange("GBOT", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 56: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("BFX", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("COM", strTemp[1]);
                            dynamicExchange.putInstruments("FUTCUR", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCOM", strTemp[1]);
                            dynamicExchange.putInstruments("OPTCUR", strTemp[1]);
                            AppConstants.dynamicList.addExchange("BFX", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 57: {
                        DynamicExchange dynamicExchange;
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange = AppConstants.dynamicList.getExchange("DCE", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                            dynamicExchange.putInstruments("OPTION", strTemp[1]);
                            AppConstants.dynamicList.addExchange("DCE", dynamicExchange);
                        }
                        strPriceWidth = "99999.9999";
                        continue block31;
                    }
                    case 43: {
                        AppConstants.bINSURANCE = true;
                        continue block31;
                    }
                    case 11: {
                        continue block31;
                    }
                    case 19: {
                        AppConstants.bCHARTS = true;
                        continue block31;
                    }
                    case 38: {
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            AppConstants.bECOINDIA = true;
                            continue block31;
                        }
                        if (Integer.parseInt(strTemp[1]) != 2) continue block31;
                        AppConstants.bECOWORLD = true;
                        continue block31;
                    }
                    case 28: {
                        continue block31;
                    }
                    case 60: {
                        DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange("ACE", strTemp[0], strTemp[2], strTemp[3], strTemp[4]);
                        if (Integer.parseInt(strTemp[1]) == 1) {
                            dynamicExchange.putInstruments("FUTURE", strTemp[1]);
                        }
                        AppConstants.dynamicList.addExchange("ACE", dynamicExchange);
                    }
                }
            }
            this.iwinapp.showform.marketwatch.initializeVariableOnMarketWatch(strPriceWidth);
            this.iwinapp.progress.setProgress("Fetching Profiles", 3);
            AppConstants.sendrequest.sendGetProfiles();
        } else {
            this.processErrorResponse(strLogonMessage, false);
        }
    }

    private void processRemoveScripResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        String strCount = this.FindValue(strResponse, Integer.toString(36));
        String strError = this.FindValue(strResponse, Integer.toString(19));
        this.processErrorResponse(strError, false);
        if (Integer.parseInt(strCount) > 0) {
            Profile profile = AppConstants.profilelist.getData(Integer.toString(AppConstants.SELECT_PROFILE_INDEX));
            TagData[] tag = profile.getTagData();
            TagData[] tempTag = new TagData[tag.length - 1];
            int Countremove = 0;
            int k = 0;
            for (int i = 0; i < tag.length; ++i) {
                if (!tag[i].strKeyOfData.equals(AppConstants.strRequestString)) {
                    tempTag[k] = tag[i];
                    ++k;
                    continue;
                }
                Countremove = i;
            }
            if (iWinRefresh.iPreviousForm == 5) {
                int maxScript = iWinRefresh.getInstance().showform.marketwatch.getMaxScriptsPerPages();
                int temp = Countremove - Countremove % maxScript;
                iWinRefresh.getInstance().showform.marketwatch.setCurrentIndex(temp);
                iWinRefresh.getInstance().showform.marketwatch.setCurrentPageStartIndex(temp);
                if (Countremove == tag.length - 1 && Countremove % maxScript == 0) {
                    iWinRefresh.getInstance().showform.marketwatch.setCurrentIndex(Countremove - maxScript);
                    iWinRefresh.getInstance().showform.marketwatch.setCurrentPageStartIndex(Countremove - maxScript);
                    if (Countremove - maxScript < 0) {
                        iWinRefresh.getInstance().showform.marketwatch.setCurrentIndex(0);
                        iWinRefresh.getInstance().showform.marketwatch.setCurrentPageStartIndex(0);
                    }
                }
            }
            Profile tempProfile = new Profile(profile.getProfileId(), profile.getProfileName(), profile.getViewType(), tempTag);
            AppConstants.profilelist.putData(Integer.toString(profile.getProfileId()), tempProfile);
        }
    }

    private void processAddScripResponse(String strResponseString) {
        int iProfileIndex = 3;
        String[] strResponse = Utilities.split(strResponseString, "|");
        String strProfileId = this.FindValue(strResponse, Integer.toString(36));
        String strError = this.FindValue(strResponse, Integer.toString(19));
        this.processErrorResponse(strError, false);
        if (Integer.parseInt(strProfileId) > 0) {
            AppConstants.SELECT_PROFILE_INDEX = Integer.parseInt(strProfileId);
            String strProfile = strResponse[iProfileIndex].replace('`', '|');
            strProfile = "`" + AppConstants.STR_PROFILE_NAME + "!" + strProfileId + "!" + strProfile;
            this.processProfileResponse(strProfile);
        }
    }

    private void processAddAlertResponse(String strResponseString) {
        int iProfileIndex = 3;
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        String strError = this.FindValue(strResponse, Integer.toString(19));
        this.processErrorResponse(strError, false);
        if (iScripCount == 1) {
            String[] strTemp = Utilities.split(strResponse[3], "$");
            if (strTemp.length == 6) {
                TagData tag = new TagData();
                tag.ExtractData(strTemp[0], strTemp[1], strTemp[2]);
                tag.iReserved = Integer.parseInt(strTemp[3]);
                tag.iPrice = Integer.parseInt(strTemp[4]);
                int iTimeStamp = Integer.parseInt(strTemp[5]);
                AppConstants.profilelist.setTimeStamp(iTimeStamp);
                AppConstants.profilelist.addAlert(tag, true);
            }
        } else if (iScripCount == 2) {
            AppConstants.profilelist.removeAlert(strResponse[3]);
            this.iwinapp.showform.showAlerts();
        }
    }

    private void processPMSResponse(String strResponseString, int iMessageCode) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        String[][] strPortfolio = null;
        String strTotalValue = "";
        int iHeaderIndex = 3;
        if (AppConstants.IsAddOrRemove.equals("remove")) {
            AppConstants.IsAddOrRemove = "";
            iWinRefresh.displayAlert("MVMG", "Portfolio Updated Successfully", AppConstants.iAlertDisplayTime);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.iwinapp.showform.showTools();
            return;
        }
        if (iCount == 0 || iCount == 0 && AppConstants.IsAddOrRemove.equals("remove")) {
            iWinRefresh.displayAlert("MVMG", "Portfolio is Empty", AppConstants.iAlertDisplayTime);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.iwinapp.showform.showTools();
            return;
        }
        if (AppConstants.IsAddOrRemove.startsWith("A")) {
            AppConstants.IsAddOrRemove = "";
            iWinRefresh.displayAlert("MVMG", "Portfolio updated successfully", AppConstants.iAlertDisplayTime);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.iwinapp.backForm(iWinRefresh.iPreviousForm);
            return;
        }
        if (AppConstants.IsSellOrBuy.equals("buy") || AppConstants.IsSellOrBuy.equals("sell")) {
            AppConstants.IsSellOrBuy = "";
            iWinRefresh.displayAlert("MVMG", "Portfolio updated successfully", AppConstants.iAlertDisplayTime);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (iMessageCode == 42) {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
            if (iCount == 0) {
                this.iwinapp.showform.showTools();
                return;
            }
            if (iCount == 3) {
                this.iwinapp.backForm(iWinRefresh.iPreviousForm);
                return;
            }
        } else {
            iHeaderIndex = 2;
        }
        if (strResponse[3].length() == 1 && iCount == 1 || strResponse[3].indexOf(38) == strResponse[3].length()) {
            this.iwinapp.showform.createPMSForm(null, "");
            return;
        }
        String[] strTemp = Utilities.split(strResponse[iHeaderIndex], "_");
        String[][] strTransaction = new String[strResponse.length - 3][5];
        int i = 3;
        int j = 0;
        while (i < strResponse.length) {
            String[] strTempTransaction = Utilities.split(strResponse[i], "^");
            for (int k = 0; k < strTempTransaction.length; ++k) {
                strTransaction[j][k] = strTempTransaction[k];
            }
            ++i;
            ++j;
        }
        int a = 0;
        for (int k = 0; k < strTransaction.length; ++k) {
            String[] temp = Utilities.split(strTransaction[k][1], "$");
            if (temp.length == 1) continue;
            ++a;
        }
        int iLength = strTransaction.length;
        String[][] strHeader = new String[iLength][4];
        strPortfolio = new String[a][4];
        int l = 0;
        for (int k = 0; k < strTransaction.length && a > 0; ++k) {
            String[] temp = Utilities.split(strTransaction[k][1], "$");
            if (temp.length == 1) continue;
            for (int j2 = 0; j2 < 4; ++j2) {
                if (j2 == 0) {
                    temp[j2] = temp[j2].substring(1);
                }
                strHeader[l][j2] = temp[j2];
                if (j2 >= 3) continue;
                strPortfolio[l][j2] = strTransaction[k][j2 + 2];
            }
            ++l;
        }
        strTotalValue = strResponse[2];
        this.iwinapp.showform.createPMSForm(strPortfolio, strTotalValue);
        this.iwinapp.showform.PortfolioWatch.setPortfolioData(strPortfolio, strTotalValue);
        this.iwinapp.showform.PortfolioWatch.setTransactionData(strTransaction);
        this.iwinapp.showform.PortfolioWatch.setHeaderData(strHeader);
    }

    private void processSessionExpiredResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        String strError = this.FindValue(strResponse, Integer.toString(19));
        this.processErrorResponse(strError, false);
    }

    private void processMarketInfoResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iNoOfEntries = strResponse.length;
        int iNoOfIndex = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        String strCurrentPage = this.FindValue(strResponse, Integer.toString(39));
        String strTotalPage = this.FindValue(strResponse, Integer.toString(40));
        String[] strOHLCResponse = Utilities.split(strResponse[iNoOfEntries - 1], "$");
        int iOHLCNoOfEntries = strOHLCResponse.length;
        String[][] strIndexData = new String[iNoOfIndex][iOHLCNoOfEntries];
        if (iNoOfIndex > 0) {
            for (int i = iNoOfEntries - iNoOfIndex; i < iNoOfEntries; ++i) {
                strOHLCResponse = Utilities.split(strResponse[i], "$");
                iOHLCNoOfEntries = strOHLCResponse.length;
                for (int j = 0; j < iOHLCNoOfEntries; ++j) {
                    strIndexData[i - (iNoOfEntries - iNoOfIndex)][j] = strOHLCResponse[j];
                }
            }
        }
        this.iwinapp.showform.createMarketInfoForm();
        this.iwinapp.showform.marketinfo.setData(strIndexData);
        if (!strCurrentPage.equals("") && !strTotalPage.equals("")) {
            this.iwinapp.showform.marketinfo.setData(Integer.parseInt(strCurrentPage), Integer.parseInt(strTotalPage));
        }
        this.iwinapp.showform.showMarketInfo();
    }

    private void processSymbolLookupResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iResponseLength = strResponse.length;
        boolean iScripDesc_Index = false;
        boolean iScripKey_Index = true;
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        if (iScripCount <= 0) {
            this.processErrorResponse("No Records Found", false);
            this.iwinapp.showform.showSelectInstrument(0);
        }
        int iPageNo = Integer.parseInt(this.FindValue(strResponse, Integer.toString(39)));
        int iTotalPages = Integer.parseInt(this.FindValue(strResponse, Integer.toString(40)));
        int iMarketSegmentId = AppConstants.iMarketSegmentId;
        int iInstrumentId = AppConstants.iInstrumentId;
        String[][] strWatchListData = new String[iScripCount][2];
        int j = 0;
        if (iScripCount > 0) {
            for (int i = iResponseLength - iScripCount; i < iResponseLength; ++i) {
                String[] strScripInfo = Utilities.split(strResponse[i], "$");
                strWatchListData[j][0] = strScripInfo[0];
                strWatchListData[j][1] = strScripInfo[1];
                ++j;
            }
            this.iwinapp.showform.getWatchListResult(true).SetScripList(AppConstants.strSearchString, strWatchListData, iPageNo, iTotalPages, iMarketSegmentId, iInstrumentId);
            this.iwinapp.showform.showMyWatchListResults(true);
        } else {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
            this.iwinapp.showform.showSelectInstrument(0);
        }
    }

    private void processNewsResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        if (iScripCount > 0) {
            String strNews = this.FindValue(strResponse, Integer.toString(327));
            String[] strNewsHeading = Utilities.split(strNews, "~");
            strNews = "";
            int iCounter = strNewsHeading.length;
            String[][] strHeader = new String[iCounter][2];
            for (int i = 0; i < iCounter; ++i) {
                String[] strTemp = Utilities.split(strNewsHeading[i], "#");
                strHeader[i][0] = strTemp[0];
                strHeader[i][1] = strTemp[1];
                strNews = strNews + strTemp[2] + "~";
            }
            if (strNews.endsWith("~")) {
                strNews = strNews.substring(0, strNews.length() - 1);
            }
            this.iwinapp.showform.showNews(strNews, true);
            this.iwinapp.showform.PortfolioWatch.setHeaderData(strHeader);
        } else {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
            this.iwinapp.backForm(iWinRefresh.iPreviousForm);
        }
    }

    private void processEconomicDataResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iResponseLength = strResponse.length;
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        if (iScripCount <= 0) {
            this.processErrorResponse("No Records Found", false);
            this.iwinapp.showform.showSelectEconSymbol();
        } else {
            int iPageNo = Integer.parseInt(this.FindValue(strResponse, Integer.toString(39)));
            int iTotalPages = Integer.parseInt(this.FindValue(strResponse, Integer.toString(40)));
            String[][] strWatchListData = new String[iScripCount][7];
            int i = 4;
            int k = 0;
            while (i < strResponse.length) {
                String[] strTemp = Utilities.split(strResponse[i], "$");
                for (int j = 0; j < strTemp.length; ++j) {
                    strWatchListData[k][j] = strTemp[j];
                }
                ++i;
                ++k;
            }
            String strCurrentPage = this.FindValue(strResponse, Integer.toString(39));
            String strTotalPage = this.FindValue(strResponse, Integer.toString(40));
            this.iwinapp.showform.createEconData();
            this.iwinapp.showform.econData.setData(strWatchListData, Integer.parseInt(strCurrentPage), Integer.parseInt(strTotalPage), "Economic Calendar");
            AppConstants.bCommonCanvasThread = true;
            this.iwinapp.showform.showEconData();
        }
    }

    private void processEconomicDetailResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        String strDetail = this.iwinapp.showform.econData.getCurrentScripName() + "``" + "Details:" + "`" + this.FindValue(strResponse, Integer.toString(19));
        strDetail = strDetail.replace('`', '\n');
        this.iwinapp.showform.showCommonForm("Economic Event Details", " ", " ", strDetail, " ", " ", " ");
    }

    private void processNewsStoryResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iRowIndex = this.iwinapp.showform.PortfolioWatch.getSelectedRow();
        String strNewsheading = this.iwinapp.showform.PortfolioWatch.getCellData(iRowIndex, 0);
        String strNewsStory = strNewsheading + "``" + strResponse[1];
        strNewsStory = strNewsStory.replace('`', '\n');
        this.iwinapp.showform.showCommonForm("News Story", " ", " ", strNewsStory, " ", " ", " ");
    }

    private void processIPOResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        int iCurrentPageNo = Integer.parseInt(this.FindValue(strResponse, Integer.toString(39)));
        int iTotalPages = Integer.parseInt(this.FindValue(strResponse, Integer.toString(40)));
        if (iScripCount > 0) {
            String[][] strData = new String[iScripCount][2];
            int iCount = strResponse.length;
            for (int i = iCount - iScripCount; i < iCount; ++i) {
                String[] strTemp = Utilities.split(strResponse[i], "$");
                String strIPODetails = "CompanyName:\n" + strTemp[0] + "\n\nOpenDate:\n" + strTemp[1] + "\n\nCloseDate:\n" + strTemp[2] + "\n\nOfferPrice:\n" + strTemp[3] + "\n\nListPrice:\n" + strTemp[4] + "\n\nIssueSize(Rs/cr):\n" + strTemp[5];
                strData[i - (iCount - iScripCount)][0] = strTemp[0];
                strData[i - (iCount - iScripCount)][1] = strIPODetails;
            }
            AppConstants.bCommonCanvasThread = true;
            this.iwinapp.showform.createCommonCanvas();
            this.iwinapp.showform.commoncanvas.setData(strData, iCurrentPageNo, iTotalPages, "IPO");
            this.iwinapp.showform.showCommonCanvas();
        } else {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
            this.iwinapp.showform.showIPO();
        }
    }

    private void processMutualFundResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        int iCurrentPageNo = Integer.parseInt(this.FindValue(strResponse, Integer.toString(39)));
        int iTotalPages = Integer.parseInt(this.FindValue(strResponse, Integer.toString(40)));
        if (iScripCount > 0) {
            String[][] strData = new String[iScripCount][3];
            int iCount = strResponse.length;
            for (int i = iCount - iScripCount; i < iCount; ++i) {
                String strMutualFundDetails;
                String[] strTemp;
                if (AppConstants.iListIndex == 0) {
                    strTemp = Utilities.split(strResponse[i], "$");
                    strMutualFundDetails = "SchemeName:\n" + strTemp[0] + "\n\nSchemeType:\n" + strTemp[1] + "\n\nSchemeCategory:\n" + strTemp[2] + "\n\nCurrent NAV:\n" + strTemp[3] + "\n\nDate:\n" + strTemp[4];
                    strData[i - (iCount - iScripCount)][0] = strTemp[0];
                    strData[i - (iCount - iScripCount)][1] = strMutualFundDetails;
                    strData[i - (iCount - iScripCount)][2] = strTemp[5];
                    continue;
                }
                if (AppConstants.iListIndex == 1) {
                    strTemp = Utilities.split(strResponse[i], "$");
                    strMutualFundDetails = "SchemeName:\n" + strTemp[0] + "\n\nSchemeType:\n" + strTemp[1] + "\n\nSchemeCategory:\n" + strTemp[2] + "\n\nLaunchDate:\n" + strTemp[3] + "\n\nCloseDate:\n" + strTemp[4] + "\n\nOfferPrice:\n" + strTemp[5] + "\n\nMin. Amount:\n" + strTemp[6];
                    strData[i - (iCount - iScripCount)][0] = strTemp[0];
                    strData[i - (iCount - iScripCount)][1] = strMutualFundDetails;
                    continue;
                }
                if (AppConstants.iListIndex != 2) continue;
                strTemp = Utilities.split(strResponse[i], "$");
                strMutualFundDetails = "FundName:\n" + strTemp[0] + "\n\nAUM-Month:\n" + strTemp[1] + "\n\nAvgExFundOfFunds:\n" + strTemp[2] + " Lakhs\n\nAvgFundOfFunds:\n" + strTemp[3] + " Lakhs";
                strData[i - (iCount - iScripCount)][0] = strTemp[0];
                strData[i - (iCount - iScripCount)][1] = strMutualFundDetails;
            }
            AppConstants.bCommonCanvasThread = true;
            this.iwinapp.showform.createCommonCanvas();
            this.iwinapp.showform.commoncanvas.setData(strData, iCurrentPageNo, iTotalPages, "Mutual Fund");
            this.iwinapp.showform.showCommonCanvas();
        } else {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
            this.iwinapp.showform.showMutualFund();
        }
    }

    private void processInsuranceResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        int iCurrentPageNo = Integer.parseInt(this.FindValue(strResponse, Integer.toString(39)));
        int iTotalPages = Integer.parseInt(this.FindValue(strResponse, Integer.toString(40)));
        if (iScripCount > 0) {
            String[][] strData = new String[iScripCount][3];
            int iCount = strResponse.length;
            for (int i = iCount - iScripCount; i < iCount; ++i) {
                String[] strTemp = Utilities.split(strResponse[i], "$");
                String strMutualFundDetails = "Policy Name:\n" + strTemp[0] + "\n\nPolicy Plan:\n" + strTemp[1] + "\n\nFund Name:\n" + strTemp[2] + "\n\nCurrent NAV:\n" + strTemp[3] + "\n\nDate:\n" + strTemp[4];
                strData[i - (iCount - iScripCount)][0] = strTemp[0];
                strData[i - (iCount - iScripCount)][1] = strMutualFundDetails;
                strData[i - (iCount - iScripCount)][2] = strTemp[5];
            }
            AppConstants.bCommonCanvasThread = true;
            this.iwinapp.showform.createCommonCanvas();
            this.iwinapp.showform.commoncanvas.setData(strData, iCurrentPageNo, iTotalPages, "Insurance");
            this.iwinapp.showform.showCommonCanvas();
        } else {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
            this.iwinapp.showform.showInsurance();
        }
    }

    private void processParityCalcResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        if (iScripCount > 0) {
            int iInitialCount = strResponse.length - iScripCount;
            for (int i = 0; i < iScripCount; ++i) {
                String[] strTemp = Utilities.split(strResponse[i + iInitialCount], "`");
                String[] strSymbolCIFCDBC = Utilities.split(strTemp[0], ",");
                if (strSymbolCIFCDBC.length != 4) continue;
                String strSymbol = strSymbolCIFCDBC[0];
                if (strSymbol.equals("GOLD")) {
                    AppConstants.defaultValues[1][0] = strSymbolCIFCDBC[1];
                    AppConstants.defaultValues[1][1] = strSymbolCIFCDBC[2];
                    AppConstants.defaultValues[1][2] = strSymbolCIFCDBC[3];
                } else if (strSymbol.equals("SILVER")) {
                    AppConstants.defaultValues[0][0] = strSymbolCIFCDBC[1];
                    AppConstants.defaultValues[0][1] = strSymbolCIFCDBC[2];
                    AppConstants.defaultValues[0][2] = strSymbolCIFCDBC[3];
                }
                String[] strpBaseContract = Utilities.split(strTemp[1], "!");
                int iBaseLength = strpBaseContract.length;
                String[][] strBaseContract = new String[iBaseLength][2];
                for (int j = 0; j < iBaseLength; ++j) {
                    String[] strResult = Utilities.split(strpBaseContract[j], "$");
                    strBaseContract[j][0] = strResult[0];
                    strBaseContract[j][1] = strResult[1];
                }
                String[] strpFutureContract = Utilities.split(strTemp[2], "!");
                int iFutureLength = strpFutureContract.length;
                String[][] strFutureContract = new String[iFutureLength][2];
                for (int j = 0; j < iFutureLength; ++j) {
                    String[] strResult = Utilities.split(strpFutureContract[j], "$");
                    strFutureContract[j][0] = strResult[0];
                    strFutureContract[j][1] = strResult[1];
                }
                ParityCalc parity = new ParityCalc(strBaseContract, strFutureContract);
                AppConstants.parityStore.putParityData(strSymbol, parity);
            }
            this.iwinapp.showform.showParityCalc();
        } else {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
            this.iwinapp.showform.showTools();
        }
    }

    private void processInteractiveChartResponse(String strResponseString) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iScripCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        String strSegmentId = this.FindValue(strResponse, Integer.toString(1));
        String strInstId = this.FindValue(strResponse, Integer.toString(29));
        String strKey = this.FindValue(strResponse, Integer.toString(45));
        String strTickData = this.FindValue(strResponse, Integer.toString(28));
        int iChartType = Integer.parseInt(this.FindValue(strResponse, Integer.toString(31)));
        switch (iChartType) {
            case 30: {
                iChartType = 4;
                break;
            }
            case 48: {
                iChartType = 6;
                break;
            }
            case 9: {
                iChartType = 7;
                break;
            }
            case 12: {
                iChartType = 5;
                break;
            }
            case 4: {
                iChartType = 8;
                break;
            }
            case 5: {
                iChartType = 9;
                break;
            }
            case 6: {
                iChartType = 10;
                break;
            }
            case 7: {
                iChartType = 11;
                break;
            }
        }
        ChartCanvas.strchartTime = Integer.toString(iChartType);
        this.iwinapp.showform.showInteractiveChart(strSegmentId, strInstId, strKey, strTickData, iChartType);
        if (iScripCount == 0) {
            String strError = this.FindValue(strResponse, Integer.toString(19));
            this.processErrorResponse(strError, false);
        }
    }

    private void processProfileNames(String strResponseString) {
        try {
            int PROFILE_START_INDEX = 2;
            int ALERT_START_INDEX = 3;
            String[] strResponse = Utilities.split(strResponseString, "|");
            String strDefaultId = this.FindValue(strResponse, Integer.toString(19));
            AppConstants.DEFUALT_PROFILE_INDEX = Integer.parseInt(strDefaultId.trim());
            if (strResponse.length >= 2) {
                this.processProfileResponse(strResponse[PROFILE_START_INDEX]);
                this.processAlertResponse(strResponse[ALERT_START_INDEX]);
            }
        }
        catch (Exception e) {
            Utilities.printLog("processProfileNames============================" + e.toString());
        }
    }

    private void processProfileResponse(String strResponseString) {
        int iInitialCount = 1;
        int Countremove = 0;
        String[] strResponse = Utilities.split(strResponseString, "`");
        try {
            for (int i = iInitialCount; i < strResponse.length; ++i) {
                String[] strProcess = Utilities.split(strResponse[i], "!");
                String strProfileName = strProcess[0];
                String strProfileId = strProcess[1];
                String[] strKey = Utilities.split(strProcess[2], "_");
                for (int l = 1; l < strKey.length; ++l) {
                    String[] strTempData = Utilities.split(strKey[l], "$");
                    String strSegmentId = strTempData[0];
                    String strInstId = strTempData[1];
                    String strProfileData = strTempData[2];
                    TagData[] objTagData = new TagData[]{new TagData()};
                    objTagData[0].ExtractData(strSegmentId, strInstId, strProfileData);
                    Profile tempProfile = AppConstants.profilelist.getData(strProfileId);
                    if (null != tempProfile) {
                        int j;
                        TagData[] tempObjTagData = tempProfile.getTagData();
                        TagData[] tagdata = new TagData[tempObjTagData.length + objTagData.length];
                        int k = 0;
                        for (j = 0; j < tempObjTagData.length; ++j) {
                            tagdata[k] = tempObjTagData[j];
                            ++k;
                        }
                        for (j = 0; j < objTagData.length; ++j) {
                            tagdata[k] = objTagData[j];
                            ++k;
                        }
                        Profile profile = new Profile(Integer.parseInt(strProfileId), strProfileName, "MARKETWATCH", tagdata);
                        AppConstants.profilelist.putData(strProfileId, profile);
                        Countremove = tagdata.length;
                        continue;
                    }
                    Profile profile = new Profile(Integer.parseInt(strProfileId), strProfileName, "MARKETWATCH", objTagData);
                    AppConstants.profilelist.putData(strProfileId, profile);
                    Countremove = objTagData.length;
                }
            }
        }
        catch (Exception e) {
            Utilities.printLog("processProfileResponse=======================" + e.toString());
        }
    }

    private void processAlertResponse(String strResponseString) {
        int iInitialCount = 1;
        try {
            String[] strResponse = Utilities.split(strResponseString, "_");
            if (strResponse.length > iInitialCount) {
                int iTimeStamp = Integer.parseInt(strResponse[0]);
                AppConstants.profilelist.setTimeStamp(iTimeStamp);
                for (int i = iInitialCount; i < strResponse.length; ++i) {
                    String[] strProcess = Utilities.split(strResponse[i], "$");
                    if (strProcess.length != 5) continue;
                    TagData tag = new TagData();
                    tag.ExtractData(strProcess[0], strProcess[1], strProcess[2]);
                    tag.iReserved = Integer.parseInt(strProcess[3]);
                    tag.iPrice = Integer.parseInt(strProcess[4]);
                    AppConstants.profilelist.addAlert(tag, false);
                }
            }
        }
        catch (Exception e) {
            Utilities.printLog("processAlertResponse======================================" + e.toString());
        }
    }

    private void processDeleteDefaultProfileResponse(String strResponseString, int iMessageCode) {
        String[] strResponse = Utilities.split(strResponseString, "|");
        int iCount = Integer.parseInt(this.FindValue(strResponse, Integer.toString(36)));
        String strError = this.FindValue(strResponse, Integer.toString(19));
        this.processErrorResponse(strError, false);
        if (iCount > 0) {
            if (iMessageCode == 45) {
                AppConstants.profilelist.removeProfile(AppConstants.SELECT_PROFILE_INDEX);
            } else if (iMessageCode == 46) {
                AppConstants.DEFUALT_PROFILE_INDEX = iCount;
            }
        }
    }

    private void processErrorResponse(String strResponse, boolean bScreenFlag) {
        try {
            iWinRefresh.displayAlert("MVMG", strResponse, AppConstants.iAlertDisplayTime);
            Thread.sleep(500L);
            if (!AppConstants.bLoggedIn) {
                this.iwinapp.assignNull();
                this.iwinapp.quit();
            } else if (bScreenFlag) {
                this.iwinapp.progress.stopProgress();
                this.iwinapp.showform.showMainMenu();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getHeaderValue(String strSource) {
        int i = strSource.indexOf("|");
        if (i > 0) {
            String strValue = strSource.substring(0, i);
            return strValue;
        }
        return "";
    }

    private String FindValue(String[] strSource, String strName) {
        int iLength = strSource.length;
        for (int i = 0; i < iLength; ++i) {
            String[] strData = Utilities.split(strSource[i], "=");
            if (!strData[0].equals(strName)) continue;
            if (strData.length == 2) {
                return strData[1];
            }
            String strTempData = "";
            for (int j = 0; j < strData.length; ++j) {
                strTempData = strTempData + strData[j] + "=";
            }
            if (strTempData.endsWith("=")) {
                strTempData = strTempData.substring(0, strTempData.length() - 1);
            }
            return strTempData;
        }
        return "";
    }
}

