/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Utilities;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class iWinDB {
    RecordStore recordStore = null;

    public iWinDB() {
    }

    public iWinDB(String fileName) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
        }
        catch (RecordStoreException rse) {
            Utilities.printLog("MVMDB " + rse.toString());
        }
    }

    public void saveRecordStore(String[][] straRecords) {
        try {
            String fileName = this.deleteRecordStore();
            this.recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
            for (int i = 0; i < straRecords.length; ++i) {
                String strData = straRecords[i][0] + "|" + straRecords[i][1];
                this.addRecordData(strData.getBytes());
            }
        }
        catch (Exception e) {
            Utilities.printLog("save " + e.toString());
        }
    }

    public void addRecordData(byte[] record) {
        try {
            this.recordStore.addRecord(record, 0, record.length);
        }
        catch (RecordStoreException rse) {
            Utilities.printLog("add " + rse.toString());
        }
    }

    public String deleteRecordStore() {
        String fileName = "";
        try {
            fileName = this.recordStore.getName();
            this.recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)fileName);
        }
        catch (Exception e) {
            Utilities.printLog("delete " + e.toString());
        }
        return fileName;
    }

    public void close() throws RecordStoreNotOpenException, RecordStoreException {
        this.recordStore.closeRecordStore();
    }

    public RecordEnumeration enumerate() throws RecordStoreNotOpenException {
        return this.recordStore.enumerateRecords(null, null, false);
    }

    public boolean findRecord(int iID) {
        try {
            RecordEnumeration recordEnumeration = this.enumerate();
            String strRecord = "";
            boolean bFound = false;
            while (recordEnumeration.hasNextElement()) {
                strRecord = new String(recordEnumeration.nextRecord());
                if (!strRecord.startsWith(iID + "|")) continue;
                bFound = true;
                return bFound;
            }
            return bFound;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEmpty() {
        try {
            if (this.recordStore.getNumRecords() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String[][] readRecordStore() {
        String[][] straRecords = null;
        try {
            RecordEnumeration enumRecord = this.enumerate();
            if (enumRecord.numRecords() > 0) {
                straRecords = new String[enumRecord.numRecords()][2];
                while (enumRecord.hasNextElement()) {
                    String temp = new String(enumRecord.nextRecord());
                    String[] data = Utilities.split(temp, "|");
                    int iID = Integer.parseInt(data[0]);
                    straRecords[iID][0] = data[0];
                    straRecords[iID][1] = data[1];
                }
            }
        }
        catch (Exception e) {
            Utilities.printLog("read " + e.toString());
        }
        return straRecords;
    }

    public byte[] LoadImage() {
        try {
            byte[] b = null;
            RecordEnumeration recordEnumeration = this.enumerate();
            while (recordEnumeration.hasNextElement()) {
                b = recordEnumeration.nextRecord();
            }
            return b;
        }
        catch (RecordStoreException rse) {
            Utilities.printLog("LoadImage " + rse.toString());
            return null;
        }
    }
}

