/*
 * Decompiled with CFR 0.152.
 */
package common;

import chart.Tick;
import common.AppConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class Utilities {
    public static String m_str;
    public static String strTick;
    public static long iTempCurrentTime;
    public static long iCompareTime;

    public static void printLog(String strValue) {
        System.out.println(strValue);
    }

    public static String ConvertToDecimal(long ipValue, int ipDivisionFactor, int ipSegmentId) {
        String strWholeNumber = Long.toString(ipValue);
        String strNegativeSign = "";
        if (ipValue == 0L) {
            return "";
        }
        if (ipValue < 0L) {
            if (ipSegmentId == 3 || ipSegmentId == 4) {
                return "";
            }
            strNegativeSign = strWholeNumber.substring(0, 1);
            strWholeNumber = strWholeNumber.substring(1);
        }
        int iLength = strWholeNumber.length();
        StringBuffer strOutput = new StringBuffer("");
        try {
            if (ipDivisionFactor == 0) {
                return strWholeNumber;
            }
            if (iLength > ipDivisionFactor) {
                strOutput.append(strNegativeSign);
                strOutput.append(strWholeNumber.substring(0, iLength - ipDivisionFactor));
                strOutput.append(".");
                strOutput.append(strWholeNumber.substring(iLength - ipDivisionFactor));
                String strTemp = strOutput.toString();
                if (strWholeNumber.substring(iLength - ipDivisionFactor).length() > 5 && strTemp.endsWith("00")) {
                    strTemp = strTemp.substring(0, strTemp.length() - 2);
                    strOutput = new StringBuffer(strTemp);
                }
                return strOutput.toString();
            }
            strOutput.append(strNegativeSign);
            strOutput.append("0.");
            for (int i = 0; i < ipDivisionFactor - iLength; ++i) {
                strOutput.append("0");
            }
            strOutput.append(strWholeNumber);
            return strOutput.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String ConvertToDecimal(float ipValue, int ipDivisionFactor, int ipSegmentId) {
        String strWholeNumber = Float.toString(ipValue);
        String strNegativeSign = "";
        if (ipValue == 0.0f) {
            return "";
        }
        if (ipValue < 0.0f) {
            if (ipSegmentId == 3 || ipSegmentId == 4) {
                return "";
            }
            strNegativeSign = strWholeNumber.substring(0, 1);
            strWholeNumber = strWholeNumber.substring(1);
        }
        int iLength = strWholeNumber.indexOf(46);
        StringBuffer strOutput = new StringBuffer("");
        try {
            if (ipDivisionFactor == 0) {
                return strWholeNumber;
            }
            if (iLength > ipDivisionFactor) {
                strOutput.append(strNegativeSign);
                strOutput.append(strWholeNumber.substring(0, iLength - ipDivisionFactor));
                strOutput.append(".");
                strOutput.append(strWholeNumber.substring(iLength - ipDivisionFactor, iLength - ipDivisionFactor + 1));
                String strTemp = strOutput.toString();
                if (strWholeNumber.substring(iLength - ipDivisionFactor).length() > 5 && strTemp.endsWith("00")) {
                    strTemp = strTemp.substring(0, strTemp.length() - 2);
                    strOutput = new StringBuffer(strTemp);
                }
                return strOutput.toString();
            }
            strOutput.append(strNegativeSign);
            strOutput.append("0.");
            for (int i = 0; i < ipDivisionFactor - iLength; ++i) {
                strOutput.append("0");
            }
            strOutput.append(strWholeNumber);
            return strOutput.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int convertToWholeNumber(String f_strPrice, int iDecimalFactor) {
        String l_strPrice = "";
        for (int i = 0; i < iDecimalFactor; ++i) {
            f_strPrice = f_strPrice + "0";
        }
        int iIndex = f_strPrice.indexOf(".");
        if (iIndex > 0) {
            l_strPrice = f_strPrice.substring(0, iIndex);
            String l_strDecimal = f_strPrice.substring(iIndex + 1, iIndex + 1 + iDecimalFactor);
            return Integer.parseInt(l_strPrice + l_strDecimal);
        }
        return Integer.parseInt(f_strPrice);
    }

    public static String ToString(int ipValue) {
        if (ipValue <= 0) {
            return "";
        }
        return Integer.toString(ipValue);
    }

    public static boolean isAlphaNumeric(String strSource, int iDot) {
        char[] strTemp = strSource.toCharArray();
        boolean bNumber = false;
        boolean bAlpha = false;
        for (int i = 0; i < strSource.length(); ++i) {
            bAlpha = false;
            bNumber = false;
            if (strTemp[i] >= '0' & strTemp[i] <= '9') {
                bNumber = true;
            }
            if (iDot == 0) {
                if (strTemp[i] >= 'A' & strTemp[i] <= 'Z') {
                    bAlpha = true;
                }
                if (strTemp[i] >= 'a' & strTemp[i] <= 'z') {
                    bAlpha = true;
                }
            } else if (iDot == 1 && strTemp[i] == '.') {
                bAlpha = true;
            }
            if (bAlpha | bNumber) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String strSource, String strDlmter) {
        int iArraySize = 32;
        String[] strTempArray = new String[iArraySize];
        String[] strOutput = null;
        String strTemp = "";
        int arrayIndex = 0;
        int i = 0;
        try {
            strTemp = strSource;
            while (true) {
                if ((i = strTemp.indexOf(strDlmter)) < 0) break;
                strTempArray[arrayIndex] = strTemp.substring(0, i);
                strTemp = strTemp.substring(i + 1, strTemp.length());
                if (++arrayIndex != iArraySize) continue;
                iArraySize = arrayIndex << 1;
                String[] temp = new String[iArraySize];
                System.arraycopy(strTempArray, 0, temp, 0, arrayIndex);
                strTempArray = temp;
                temp = null;
            }
            strTempArray[arrayIndex] = strTemp;
            strOutput = new String[arrayIndex + 1];
            for (i = 0; i <= arrayIndex; ++i) {
                strOutput[i] = strTempArray[i];
            }
            strTempArray = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strOutput;
    }

    public static String RemoveNull(byte[] f_btTemp) {
        String l_strTemp = "";
        try {
            l_strTemp = new String(f_btTemp, "UTF-8");
        }
        catch (Exception e) {
            l_strTemp = new String(f_btTemp);
        }
        if (l_strTemp.indexOf(0) >= 0) {
            l_strTemp = l_strTemp.substring(0, l_strTemp.indexOf(0));
        }
        return l_strTemp.trim();
    }

    public static long processDataType(DataInputStream l_objDataInputStream, int f_nValue, int f_nBaseValue) {
        long l_nMsgData = 0L;
        int l_tempValue = f_nValue >> 3;
        try {
            int l_nMsgDataType = f_nValue - (l_tempValue << 3);
            switch (l_nMsgDataType) {
                case 1: {
                    l_nMsgData = l_objDataInputStream.readByte();
                    break;
                }
                case 2: {
                    l_nMsgData = l_objDataInputStream.readShort();
                    break;
                }
                case 3: {
                    l_nMsgData = l_objDataInputStream.readInt();
                    break;
                }
                case 4: {
                    l_objDataInputStream.skip(8L);
                    break;
                }
                case 5: {
                    l_nMsgData = l_objDataInputStream.readLong();
                }
            }
        }
        catch (IOException ex) {
            l_nMsgData = 0L;
            ex.printStackTrace();
        }
        if (l_tempValue < 0) {
            l_tempValue = -l_tempValue;
        }
        if (l_tempValue == 1) {
            l_nMsgData += (long)f_nBaseValue;
        }
        return l_nMsgData;
    }

    public static String GetFormattedTime(int f_nMsgTimeStamp) {
        try {
            long l_ntemp = ((long)f_nMsgTimeStamp + 315513000L) * 1000L + 19800000L;
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            Date date = new Date(l_ntemp);
            calendar.setTime(date);
            String day = String.valueOf(calendar.get(5));
            String month = String.valueOf(calendar.get(2));
            String year = String.valueOf(calendar.get(1));
            System.out.println("" + day + "/" + month + "/" + year);
            String l_strHours = String.valueOf(calendar.get(11));
            String l_strMinutes = String.valueOf(calendar.get(12));
            String l_strSeconds = String.valueOf(calendar.get(13));
            if (calendar.get(11) < 10) {
                l_strHours = "0" + l_strHours;
            }
            if (calendar.get(12) < 10) {
                l_strMinutes = "0" + l_strMinutes;
            }
            if (calendar.get(13) < 10) {
                l_strSeconds = "0" + l_strSeconds;
            }
            String l_strTime = l_strHours + ":" + l_strMinutes + ":" + l_strSeconds;
            return l_strTime;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Fail";
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public static boolean getTickBool(Tick objTick) {
        boolean l_bforAddOrcalc = false;
        Vector<Tick> vTick = new Vector<Tick>();
        if (AppConstants.FirstTime) {
            AppConstants.FirstTime = false;
            long iTempCurrentTime = System.currentTimeMillis();
            long iModOfCurrentTime = iTempCurrentTime % 60L;
            long iCompareTime = iTempCurrentTime - iModOfCurrentTime;
        }
        if (System.currentTimeMillis() < iCompareTime + 60L) {
            vTick.addElement(objTick);
            l_bforAddOrcalc = true;
        } else {
            Utilities.calculateOneTick(vTick);
            l_bforAddOrcalc = false;
            iTempCurrentTime = 0L;
        }
        return l_bforAddOrcalc;
    }

    public static String calculateOneTick(Vector vobjTick) {
        int nHigh = 0;
        int nLow = 0;
        int nOpen = 0;
        int nCLose = 0;
        for (int i = 0; i < vobjTick.size(); ++i) {
            Tick tempTick = (Tick)vobjTick.elementAt(i);
            if (i == 0) {
                nOpen = tempTick.m_nOpen;
            }
            if (i == vobjTick.size() - 1) {
                nCLose = tempTick.m_nLTP;
            }
            if (tempTick.m_nHigh > nHigh) {
                nHigh = tempTick.m_nHigh;
            }
            if (tempTick.m_nLow <= nLow) continue;
            nLow = tempTick.m_nLow;
        }
        strTick = nCLose + "~" + nOpen + "~" + nHigh + "~" + nLow;
        return strTick;
    }

    public static String getCalculatedOneTick() {
        return strTick;
    }
}

