/*
 * Decompiled with CFR 0.152.
 */
package chart;

import GeneralUI.JPlatformCanvas;
import chart.ChartGenerator;
import chart.DataToPlotted;
import chart.Tick;
import common.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Indicators {
    private ChartGenerator m_objChartGenerator = new ChartGenerator();
    private int[] m_nTotalTicks;
    private Vector m_objPaintingTicks;
    private int m_nPx = 0;
    private int m_nMax;
    private int m_nMin;
    private int m_nStartIndex = 0;
    private int m_nEndIndex = 0;
    private int m_nXCordinate;
    private int m_nYcordinate;
    private int m_nIndicatorType = 0;
    private int m_nTypeOfChart = 1;
    private int m_nHeight = 0;
    private int m_nWidth = 0;
    private int m_nPeriod = 9;
    private int m_nFormulaIndex = 0;
    private String m_strMultiplier = "";
    int m_nMultiplier = 1;
    int m_nMultiplierDivFactor = 1;
    int m_nSuperTrendAggregated = 0;
    int[] m_nColorArray;
    boolean m_bSuperTrendFlag = true;
    boolean m_bTrendFirstValueFlag = true;

    public void setInitialValues(int f_nXCordinate, int f_nYCordinate, int f_nWidth, int f_nHeight) {
        this.m_nXCordinate = f_nXCordinate;
        this.m_nYcordinate = f_nYCordinate;
        this.m_nWidth = f_nWidth;
        this.m_nHeight = f_nHeight;
    }

    public void setPeriod(int f_nPeriod) {
        this.m_nPeriod = f_nPeriod;
    }

    public int getPeriod() {
        return this.m_nPeriod;
    }

    public void setTypeOfChart(int f_nTypeOfChart) {
        this.m_nTypeOfChart = f_nTypeOfChart;
    }

    public void setIndicatorType(int f_nIndicatorType) {
        this.m_nIndicatorType = f_nIndicatorType;
    }

    public int getIndicatorType() {
        return this.m_nIndicatorType;
    }

    public void setFormulaIndex(int f_nFormulaIndex) {
        this.m_nFormulaIndex = f_nFormulaIndex;
    }

    public void setMultiplier(String f_strMultiplier) {
        this.m_strMultiplier = f_strMultiplier;
        int iIndex = f_strMultiplier.indexOf(".");
        if (iIndex > 0) {
            int iDecimalPoint = f_strMultiplier.substring(iIndex + 1).length();
            this.m_nMultiplierDivFactor = iDecimalPoint * 10;
            this.m_nMultiplier = Utilities.convertToWholeNumber(f_strMultiplier, iDecimalPoint);
        } else {
            this.m_nMultiplierDivFactor = 1;
            this.m_nMultiplier = Integer.parseInt(f_strMultiplier);
        }
    }

    public String getMultiplier() {
        return this.m_strMultiplier;
    }

    public void prepareIndicatorData(Vector f_objData) {
        switch (this.m_nIndicatorType) {
            case 0: {
                this.prepareMovingAverageData(f_objData);
                break;
            }
            case 1: {
                this.preparePivotPointData(f_objData);
                break;
            }
            case 2: {
                this.prepareSuperTrendData(f_objData);
            }
        }
    }

    private void prepareMovingAverageData(Vector f_objData) {
        int l_nCounter = f_objData.size();
        if (this.m_nTotalTicks != null) {
            this.m_nTotalTicks = null;
        }
        this.m_nTotalTicks = new int[l_nCounter];
        if (l_nCounter <= this.m_nPeriod) {
            return;
        }
        int l_nLastLTPSum = 0;
        for (int i = 0; i < l_nCounter; ++i) {
            switch (this.m_nFormulaIndex) {
                case 0: {
                    l_nLastLTPSum += ((Tick)f_objData.elementAt((int)i)).m_nLTP;
                    if (i <= this.m_nPeriod - 1) break;
                    int l_nPreLTP = ((Tick)f_objData.elementAt((int)(i - this.m_nPeriod))).m_nLTP;
                    l_nLastLTPSum -= l_nPreLTP;
                    break;
                }
                case 1: {
                    l_nLastLTPSum += ((Tick)f_objData.elementAt((int)i)).m_nOpen;
                    if (i <= this.m_nPeriod - 1) break;
                    int l_nPreLTP = ((Tick)f_objData.elementAt((int)(i - this.m_nPeriod))).m_nOpen;
                    l_nLastLTPSum -= l_nPreLTP;
                    break;
                }
                case 2: {
                    l_nLastLTPSum += ((Tick)f_objData.elementAt((int)i)).m_nHigh;
                    if (i <= this.m_nPeriod - 1) break;
                    int l_nPreLTP = ((Tick)f_objData.elementAt((int)(i - this.m_nPeriod))).m_nHigh;
                    l_nLastLTPSum -= l_nPreLTP;
                    break;
                }
                case 3: {
                    l_nLastLTPSum += ((Tick)f_objData.elementAt((int)i)).m_nLow;
                    if (i <= this.m_nPeriod - 1) break;
                    int l_nPreLTP = ((Tick)f_objData.elementAt((int)(i - this.m_nPeriod))).m_nLow;
                    l_nLastLTPSum -= l_nPreLTP;
                }
            }
            int iLTP = l_nLastLTPSum / this.m_nPeriod;
            if (i < this.m_nPeriod - 1) {
                iLTP = 0;
            }
            this.m_nTotalTicks[i] = iLTP;
        }
    }

    private void prepareSuperTrendData(Vector f_objData) {
        Tick tick;
        int i;
        int l_nCounter = f_objData.size();
        if (this.m_nTotalTicks != null) {
            this.m_nTotalTicks = null;
        }
        this.m_nTotalTicks = new int[l_nCounter];
        this.m_nColorArray = new int[l_nCounter];
        if (l_nCounter <= this.m_nPeriod) {
            return;
        }
        this.m_nTotalTicks[0] = 0;
        this.m_nColorArray[0] = 0x50FF50;
        int l_nPreviousLTP = 0;
        int l_nATRFormulaValue = 0;
        int l_nATR = 0;
        int l_nMedianPrice = 0;
        boolean l_nSuperUpTrend = false;
        boolean l_nSuperDownTrend = false;
        int l_nLTP = 0;
        for (i = 1; i < this.m_nPeriod; ++i) {
            this.m_nTotalTicks[i] = 0;
            this.m_nColorArray[i] = 0x50FF50;
            tick = (Tick)f_objData.elementAt(i);
            l_nPreviousLTP += Math.max(Math.max(Math.abs(tick.m_nHigh - tick.m_nLow), Math.abs(tick.m_nHigh - tick.m_nLTP)), Math.abs(tick.m_nLow - tick.m_nLTP));
        }
        if (this.m_nPeriod != 1) {
            l_nPreviousLTP /= this.m_nPeriod - 1;
        }
        for (i = this.m_nPeriod; i < l_nCounter; ++i) {
            tick = (Tick)f_objData.elementAt(i);
            l_nATRFormulaValue = Math.max(Math.max(Math.abs(tick.m_nHigh - tick.m_nLow), Math.abs(tick.m_nHigh - tick.m_nLTP)), Math.abs(tick.m_nLow - tick.m_nLTP));
            l_nPreviousLTP = l_nATR = (l_nATRFormulaValue + l_nPreviousLTP * (this.m_nPeriod - 1)) / this.m_nPeriod;
            l_nMedianPrice = (tick.m_nHigh + tick.m_nLow) / 2;
            l_nLTP = tick.m_nLTP;
            if (this.m_bSuperTrendFlag) {
                this.UpTrendComputation(l_nLTP, l_nMedianPrice, l_nATR, i);
                continue;
            }
            this.DownTrendComputation(l_nLTP, l_nMedianPrice, l_nATR, i);
        }
    }

    public void UpTrendComputation(int f_nLTP, int f_nMedianPrice, int f_nATR, int f_nCounter) {
        int l_nSuperUpTrend = f_nMedianPrice - f_nATR * this.m_nMultiplier / this.m_nMultiplierDivFactor;
        if (this.m_bTrendFirstValueFlag) {
            this.m_nSuperTrendAggregated = l_nSuperUpTrend;
            this.m_bTrendFirstValueFlag = false;
        } else if (this.m_nSuperTrendAggregated < l_nSuperUpTrend) {
            this.m_nSuperTrendAggregated = l_nSuperUpTrend;
        }
        if (f_nLTP < this.m_nSuperTrendAggregated) {
            this.m_bSuperTrendFlag = false;
            this.m_bTrendFirstValueFlag = true;
            this.DownTrendComputation(f_nLTP, f_nMedianPrice, f_nATR, f_nCounter);
        } else {
            this.m_nTotalTicks[f_nCounter] = this.m_nSuperTrendAggregated;
            this.m_nColorArray[f_nCounter] = 3448628;
        }
    }

    public void DownTrendComputation(int f_nLTP, int f_nMedianPrice, int f_nATR, int f_nCounter) {
        int l_nSuperDownTrend = f_nMedianPrice + f_nATR * this.m_nMultiplier / this.m_nMultiplierDivFactor;
        if (this.m_bTrendFirstValueFlag) {
            this.m_nSuperTrendAggregated = l_nSuperDownTrend;
            this.m_bTrendFirstValueFlag = false;
        } else if (this.m_nSuperTrendAggregated > l_nSuperDownTrend) {
            this.m_nSuperTrendAggregated = l_nSuperDownTrend;
        }
        if (f_nLTP > this.m_nSuperTrendAggregated) {
            this.m_bSuperTrendFlag = true;
            this.m_bTrendFirstValueFlag = true;
            this.UpTrendComputation(f_nLTP, f_nMedianPrice, f_nATR, f_nCounter);
        } else {
            this.m_nTotalTicks[f_nCounter] = this.m_nSuperTrendAggregated;
            this.m_nColorArray[f_nCounter] = 15141900;
        }
    }

    private void preparePivotPointData(Vector f_objData) {
        int l_nCounter = f_objData.size();
        this.m_nTotalTicks = new int[l_nCounter];
        this.ClearPaintingTicks();
        int iDivisionFactor = ((Tick)f_objData.elementAt((int)0)).m_nDivisionFactor;
        String strDate = ((Tick)f_objData.elementAt((int)0)).m_strDate;
        Tick tick = new Tick(0L, 0, 0, 0, 0, 0, 0, 0, strDate, iDivisionFactor);
        this.m_objPaintingTicks.addElement(tick);
        for (int i = 1; i < l_nCounter; ++i) {
            int iLTP = ((Tick)f_objData.elementAt((int)(i - 1))).m_nLTP;
            int iHigh = ((Tick)f_objData.elementAt((int)(i - 1))).m_nHigh;
            int iLow = ((Tick)f_objData.elementAt((int)(i - 1))).m_nLow;
            int iTodayOpen = ((Tick)f_objData.elementAt((int)i)).m_nOpen;
            strDate = ((Tick)f_objData.elementAt((int)i)).m_strDate;
            int l_nPivotPoint = 0;
            switch (this.m_nFormulaIndex) {
                case 0: {
                    l_nPivotPoint = (iHigh + iLow + iLTP) / 3;
                    break;
                }
                case 1: {
                    l_nPivotPoint = (iHigh + iLow + iLTP + iTodayOpen) / 4;
                    break;
                }
                case 2: {
                    l_nPivotPoint = (iHigh + iLow + iTodayOpen) / 3;
                }
            }
            int l_nResistor1 = 2 * l_nPivotPoint - iLow;
            int l_nResistor2 = l_nPivotPoint + (iHigh - iLow);
            int l_nSupportPoint1 = 2 * l_nPivotPoint - iHigh;
            int l_nSupportPoint2 = l_nPivotPoint - (iHigh - iLow);
            tick = new Tick(0L, l_nPivotPoint, l_nResistor1, l_nResistor2, l_nSupportPoint1, l_nSupportPoint2, 0, 0, strDate, iDivisionFactor);
            this.m_objPaintingTicks.addElement(tick);
        }
    }

    public synchronized void getDataToPlot(int f_nMax, int f_nMin, int f_nStartIndex, int f_nEndIndex, int f_nPx) {
        try {
            this.m_nPx = f_nPx;
            this.m_nStartIndex = f_nStartIndex;
            this.m_nEndIndex = f_nEndIndex;
            this.m_nMax = 0;
            this.m_nMin = 0;
            switch (this.m_nIndicatorType) {
                case 0: 
                case 2: {
                    this.ClearPaintingTicks();
                    if (this.m_nTotalTicks == null || this.m_nTotalTicks.length == 0) {
                        return;
                    }
                    this.m_nMax = f_nMax;
                    this.m_nMin = f_nMin;
                    int m_nXPoint = 0;
                    for (int i = this.m_nStartIndex; i <= this.m_nEndIndex; ++i) {
                        int iLTP = this.m_nTotalTicks[i];
                        int m_nYPoint = 0;
                        m_nYPoint = iLTP == 0 ? -1 : this.m_nHeight * (iLTP - this.m_nMin) / (this.m_nMax - this.m_nMin);
                        DataToPlotted l_objDataToPlotted = new DataToPlotted(null, m_nXPoint += this.m_nPx, m_nYPoint);
                        this.m_objPaintingTicks.addElement(l_objDataToPlotted);
                    }
                    break;
                }
            }
            this.m_nStartIndex = 0;
            this.m_nEndIndex = this.m_objPaintingTicks.size();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void ClearPaintingTicks() {
        if (this.m_objPaintingTicks != null) {
            this.m_objPaintingTicks.removeAllElements();
            this.m_objPaintingTicks = null;
        }
        this.m_objPaintingTicks = new Vector();
    }

    public void paintIndicator(Graphics g, Font f, int f_nStartIndex, int f_nIndex) {
        if (this.m_nTotalTicks == null || this.m_nTotalTicks.length == 0) {
            return;
        }
        if (0 == this.m_nIndicatorType) {
            this.m_objChartGenerator.LineChartGenerator(g, this.m_objPaintingTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex);
        } else if (1 == this.m_nIndicatorType) {
            this.paintPivotPoint(g, f, f_nStartIndex + f_nIndex);
        }
        if (2 == this.m_nIndicatorType) {
            this.m_objChartGenerator.LineChartGeneratorForSuperTrend(g, this.m_objPaintingTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex, this.m_nColorArray, f_nStartIndex);
        }
    }

    private void paintPivotPoint(Graphics g, Font f, int f_nIndex) {
        int iFontHeight = f.getHeight();
        int l_nDivisionFactor = ((Tick)this.m_objPaintingTicks.elementAt((int)f_nIndex)).m_nDivisionFactor;
        String strDate = ((Tick)this.m_objPaintingTicks.elementAt((int)f_nIndex)).m_strDate;
        String l_strPivotPoint = Utilities.ConvertToDecimal(((Tick)this.m_objPaintingTicks.elementAt((int)f_nIndex)).m_nLTP, l_nDivisionFactor, 1);
        String l_strResist1 = Utilities.ConvertToDecimal(((Tick)this.m_objPaintingTicks.elementAt((int)f_nIndex)).m_nOpen, l_nDivisionFactor, 1);
        String l_strResist2 = Utilities.ConvertToDecimal(((Tick)this.m_objPaintingTicks.elementAt((int)f_nIndex)).m_nHigh, l_nDivisionFactor, 1);
        String l_strSupport1 = Utilities.ConvertToDecimal(((Tick)this.m_objPaintingTicks.elementAt((int)f_nIndex)).m_nLow, l_nDivisionFactor, 1);
        String l_strSupport2 = Utilities.ConvertToDecimal(((Tick)this.m_objPaintingTicks.elementAt((int)f_nIndex)).m_nPreviousClose, l_nDivisionFactor, 1);
        int iImageWidth = f.stringWidth("pvt : 000000000") + 10;
        int iStartPoint = JPlatformCanvas.TITLE_BAR_HEIGHT * 2;
        g.setColor(0);
        g.fillRect(0, iStartPoint, iImageWidth, iFontHeight * 6);
        g.setFont(f);
        g.setColor(0xFFFFFF);
        int x = 5;
        g.drawString(strDate, iImageWidth / 2, iStartPoint + iFontHeight * 0, 0x10 | 1);
        g.drawString("Pvt : " + l_strPivotPoint, x, iStartPoint + iFontHeight * 1, 0x10 | 4);
        g.drawString("R1  : " + l_strResist1, x, iStartPoint + iFontHeight * 2, 0x10 | 4);
        g.drawString("R2  : " + l_strResist2, x, iStartPoint + iFontHeight * 3, 0x10 | 4);
        g.drawString("S1  : " + l_strSupport1, x, iStartPoint + iFontHeight * 4, 0x10 | 4);
        g.drawString("S2  : " + l_strSupport2, x, iStartPoint + iFontHeight * 5, 0x10 | 4);
    }

    public String getAverageLTP(int f_nIndex, int f_nDivisionFactor) {
        int l_nLTP = this.m_nTotalTicks[f_nIndex];
        return Utilities.ConvertToDecimal(l_nLTP, f_nDivisionFactor, 1);
    }
}

