/*
 * Decompiled with CFR 0.152.
 */
package chart;

import common.Utilities;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CYAxis {
    private int m_nMin;
    private int m_nMax;
    private int m_nPricesion;
    private int m_nNoOfUnits;
    private int m_nStartX;
    private int m_nStartY;
    private int m_nWidth;
    private int m_nHeight;
    private Font f = Font.getFont((int)0, (int)0, (int)8);

    public void setInitialvalue(int f_nStartX, int f_nStartY, int f_nWidth, int f_nHeight) {
        this.m_nStartX = f_nStartX;
        this.m_nStartY = f_nStartY;
        this.m_nWidth = f_nWidth;
        this.m_nHeight = f_nHeight;
    }

    public void AssignValues(int f_nMin, int f_nMax, int f_nNoOfUnits, int f_nPricesion) {
        this.m_nMin = f_nMin;
        this.m_nMax = f_nMax;
        this.m_nNoOfUnits = f_nNoOfUnits;
        this.m_nPricesion = f_nPricesion;
    }

    public void paintYAxis(Graphics g, int f_nTypeOfChart) {
        int iDifference = (this.m_nMax - this.m_nMin) / this.m_nNoOfUnits;
        g.setFont(this.f);
        int iOffset = 3;
        for (int i = 0; i < this.m_nNoOfUnits; ++i) {
            g.setColor(212, 208, 200);
            int l_nY = this.m_nHeight / this.m_nNoOfUnits * i;
            g.drawLine(0, l_nY + 1 + this.m_nStartY, this.m_nWidth - 1 + this.m_nStartX, l_nY + 1 + this.m_nStartY);
            int iTemp = this.m_nMax - iDifference * i;
            g.setColor(0, 0, 0);
            g.drawString(this.getPricesionValue(iTemp, f_nTypeOfChart), this.m_nWidth + iOffset + this.m_nStartX, l_nY + this.m_nStartY - iOffset, 0x10 | 4);
        }
        g.setColor(0, 0, 0);
        g.drawLine(this.m_nStartX, this.m_nHeight + this.m_nStartY, this.m_nWidth + this.m_nStartX, this.m_nHeight + this.m_nStartY);
        g.drawString(this.getPricesionValue(this.m_nMin, f_nTypeOfChart), this.m_nWidth + iOffset + this.m_nStartX, this.m_nHeight + this.m_nStartY - iOffset, 0x10 | 4);
    }

    private String getPricesionValue(int f_nLastValue, int f_nTypeOfChart) {
        float l_nLastValue;
        String l_strTempMax = "";
        float f = l_nLastValue = f_nTypeOfChart == 2 ? (float)f_nLastValue : (float)f_nLastValue / (float)Utilities.convertToWholeNumber(Integer.toString(1), this.m_nPricesion);
        l_strTempMax = l_nLastValue >= 10000.0f && l_nLastValue < 100000.0f ? Utilities.ConvertToDecimal(l_nLastValue /= 100.0f, 1, 2) + "K" : (l_nLastValue >= 100000.0f && l_nLastValue < 1000000.0f ? (l_nLastValue /= 1000.0f) + "K" : (l_nLastValue >= 1000000.0f && l_nLastValue < 1.0E7f ? Utilities.ConvertToDecimal(l_nLastValue /= 10000.0f, 2, 2) + "M" : (l_nLastValue >= 1.0E7f ? Utilities.ConvertToDecimal(l_nLastValue /= 100000.0f, 1, 2) + "M" : Float.toString(l_nLastValue))));
        return l_strTempMax;
    }
}

