/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.DrawText;
import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import common.AppConstants;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Table {
    private byte iColumn;
    private byte iRow;
    private short iMaxNumberOfRows;
    private short iMaxNumberOfColumns;
    private int[] iCellsWidth;
    private int[] iCellsHeight;
    private int[] iCellsXPos;
    private int[] iCellsYPos;
    private String[][] iCellData;
    public String[][][] iDisplayableData;
    private int[] iColumnOrientation;
    private String[] iHeaderText;
    private int iTotalAreaWidth;
    private int iTotalAreaHeight;
    private int iHorrizontalScroll;
    private int iVerticleScroll;
    private int iXCoordinate;
    private int iYCoordinate;
    private int iBgColor;
    private int iBorderDepth;
    private int iBorderColor;
    private int iDataVerticleOffsetInCell;
    private int iDataHorrizonatlOffsetInCell;
    private int iHeaderBarHeight;
    public static final byte LEFT = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;
    public String strMainHeading = "";
    public String strTotalValue = "";
    public static final byte WRAP_TEXT_OFF = 0;
    public static final byte WRAP_TEXT_ON = 1;
    private byte WRAP_TEXT = 0;
    private int FONT_STYLE;

    public Table(String[] ColumnTitle, String[][] newRowColData, int newWidth, int newHeight, int FontType) {
        this.iTotalAreaWidth = newWidth;
        this.iTotalAreaHeight = newHeight;
        this.FONT_STYLE = FontType;
        this.initializeVariables();
        this.setRowColData(ColumnTitle, newRowColData);
    }

    public void initialize(String[] ColumnTitle, String[][] newRowColData, int newWidth, int newHeight, int FontType) {
        this.iTotalAreaWidth = newWidth;
        this.iTotalAreaHeight = newHeight;
        this.FONT_STYLE = FontType;
        this.initializeVariables();
        this.setRowColData(ColumnTitle, newRowColData);
    }

    public Table() {
    }

    public void initializeVariables() {
        this.iColumn = 0;
        this.iRow = 0;
        this.iMaxNumberOfRows = 0;
        this.iMaxNumberOfColumns = 0;
        this.iCellsWidth = null;
        this.iCellsHeight = null;
        this.iCellsXPos = null;
        this.iCellsYPos = null;
        this.iCellData = null;
        this.iDisplayableData = null;
        this.iHorrizontalScroll = 0;
        this.iVerticleScroll = 0;
        this.iXCoordinate = 0;
        this.iYCoordinate = 0;
        this.iBgColor = 0xFFFFFF;
        this.iBorderDepth = 1;
        this.iBorderColor = 0x949494;
        this.iDataVerticleOffsetInCell = 2;
        this.iDataHorrizonatlOffsetInCell = 1;
    }

    private void setRowColData(String[] ColumnTitle, String[][] newRowColData) {
        if (ColumnTitle != null && ColumnTitle.length > 0) {
            this.iHeaderText = ColumnTitle;
        }
        if (newRowColData != null && newRowColData.length > 0) {
            this.iCellData = newRowColData;
            this.iMaxNumberOfRows = (byte)this.iCellData.length;
            this.iMaxNumberOfColumns = (byte)ColumnTitle.length;
            this.calculate();
            int length = this.iColumnOrientation.length;
            for (int col = 0; col < length; ++col) {
                this.setColumnOrientation(col, 0);
            }
        }
    }

    public void setFitPolicy(byte fitPolicy) {
        if (fitPolicy == 0 | fitPolicy == 1) {
            this.WRAP_TEXT = fitPolicy;
            this.resetGrid(this.iHeaderText, this.iCellData);
        }
    }

    public void setColumnOrientation(int col, int newOrient) {
        if (col >= 0 && col < this.iMaxNumberOfColumns) {
            this.iColumnOrientation[col] = newOrient;
            DrawText.setStrip(this.FONT_STYLE);
            if (this.WRAP_TEXT == 0) {
                for (int rows = 0; rows < this.iMaxNumberOfRows; ++rows) {
                    int cellDataWidth = DrawText.getWidth(this.iCellData[rows][col]);
                    if (cellDataWidth < this.iCellsWidth[col]) continue;
                    String tmpStr = this.iCellData[rows][col];
                    int counter = 0;
                    int tmpStrWidth = 0;
                    char[] tmpCharArray = this.iDisplayableData[rows][col][0].toCharArray();
                    int charArrayLen = tmpCharArray.length;
                    StringBuffer buffer = new StringBuffer();
                    for (int z = 0; z < charArrayLen && tmpStrWidth < this.iCellsWidth[col] + this.iBorderDepth; ++z) {
                        tmpStrWidth += DrawText.getcharWidth(tmpCharArray[z]);
                        ++counter;
                    }
                    switch (this.iColumnOrientation[col]) {
                        case 2: {
                            buffer.append("...");
                            int newStrLen = tmpStr.length();
                            buffer.append(tmpStr.substring(newStrLen - counter + 2, newStrLen));
                            this.iDisplayableData[rows][col][0] = buffer.toString();
                            break;
                        }
                        case 0: {
                            buffer.append(tmpStr.substring(0, counter - 2).trim());
                            buffer.append("...");
                            this.iDisplayableData[rows][col][0] = buffer.toString();
                        }
                    }
                    tmpStr = null;
                }
            }
        }
    }

    public void setHeaderText(int col, String newText) {
        if (col >= 0 && col < this.iMaxNumberOfColumns) {
            this.iHeaderText[col] = newText;
        }
    }

    private void calculate() {
        if (this.iCellsYPos == null) {
            this.iCellsYPos = new int[this.iMaxNumberOfRows];
        }
        if (this.iCellsXPos == null) {
            this.iCellsXPos = new int[this.iMaxNumberOfColumns];
        }
        if (this.iCellsWidth == null) {
            this.iCellsWidth = new int[this.iMaxNumberOfColumns];
        }
        if (this.iCellsHeight == null) {
            this.iCellsHeight = new int[this.iMaxNumberOfRows];
        }
        if (this.iDisplayableData == null) {
            this.iDisplayableData = new String[this.iMaxNumberOfRows][][];
        }
        if (this.iColumnOrientation == null) {
            this.iColumnOrientation = new int[this.iMaxNumberOfColumns];
        }
        if (this.iHeaderText == null) {
            this.iHeaderText = new String[this.iMaxNumberOfColumns];
            for (int col = 0; col < this.iMaxNumberOfColumns; ++col) {
                this.iHeaderText[col] = "";
            }
        }
        int DefaultWidthPerColumn = (this.iTotalAreaWidth - this.iMaxNumberOfColumns * (this.iDataHorrizonatlOffsetInCell + this.iBorderDepth) - this.iBorderDepth) / this.iMaxNumberOfColumns;
        int RemainingAreaWidth = 0;
        int Count = 0;
        DrawText.setStrip(this.FONT_STYLE);
        for (int col = 0; col < this.iMaxNumberOfColumns; ++col) {
            int tmpColumnWidth = 0;
            int iColTitleWidth = this.iHeaderText != null ? DrawText.getWidth(this.iHeaderText[col]) : 0;
            for (int row = 0; row < this.iMaxNumberOfRows; ++row) {
                tmpColumnWidth = Math.max(tmpColumnWidth, Math.max(DrawText.getWidth(this.iCellData[row][col]), DefaultWidthPerColumn > iColTitleWidth ? iColTitleWidth + DrawText.getcharWidth('W') : DefaultWidthPerColumn));
            }
            if (tmpColumnWidth < DefaultWidthPerColumn) {
                this.iCellsWidth[col] = tmpColumnWidth;
                RemainingAreaWidth += DefaultWidthPerColumn - tmpColumnWidth;
                continue;
            }
            this.iCellsWidth[col] = DefaultWidthPerColumn;
            ++Count;
        }
        for (int Cols = 0; Cols < this.iMaxNumberOfColumns; ++Cols) {
            if (Count > 0 && DefaultWidthPerColumn > 0 && this.iCellsWidth[Cols] == DefaultWidthPerColumn) {
                int n = Cols;
                this.iCellsWidth[n] = this.iCellsWidth[n] + RemainingAreaWidth / Count;
            } else if (Count == 0 && RemainingAreaWidth > 0) {
                int n = Cols;
                this.iCellsWidth[n] = this.iCellsWidth[n] + RemainingAreaWidth / this.iMaxNumberOfColumns;
            }
            this.iCellsXPos[Cols] = this.iXCoordinate;
            int n = Cols;
            this.iCellsWidth[n] = this.iCellsWidth[n] + (this.iDataHorrizonatlOffsetInCell << 1);
            this.iXCoordinate += this.iCellsWidth[Cols] + this.iBorderDepth;
        }
        this.iXCoordinate += this.iBorderDepth;
        for (int Rows = 0; Rows < this.iMaxNumberOfRows; ++Rows) {
            this.iDisplayableData[Rows] = new String[this.iMaxNumberOfColumns][];
            for (int Cols = 0; Cols < this.iMaxNumberOfColumns; ++Cols) {
                switch (this.WRAP_TEXT) {
                    case 0: {
                        this.iDisplayableData[Rows][Cols] = new String[1];
                        this.iDisplayableData[Rows][Cols][0] = this.iCellData[Rows][Cols];
                        break;
                    }
                    case 1: {
                        this.iDisplayableData[Rows][Cols] = Table.formatTextInCells(this.iCellData[Rows][Cols], ' ', this.FONT_STYLE, this.iCellsWidth[Cols]);
                    }
                }
                this.iCellsHeight[Rows] = Math.max(this.iCellsHeight[Rows], this.iDisplayableData[Rows][Cols].length * (DrawText.getHeight() + this.iDataVerticleOffsetInCell) - (this.iDisplayableData[Rows][Cols].length <= 0 ? 0 : this.iDataVerticleOffsetInCell));
            }
            int n = Rows;
            this.iCellsHeight[n] = this.iCellsHeight[n] + (this.iDataHorrizonatlOffsetInCell << 1);
            this.iCellsYPos[Rows] = this.iYCoordinate;
            this.iYCoordinate += this.iCellsHeight[Rows] + this.iBorderDepth;
        }
        this.iYCoordinate += this.iBorderDepth;
    }

    public final void draw(Graphics g1, int iClipWidth, int iClipHeight) {
        if (this.iMaxNumberOfRows <= 0) {
            DrawText.setStrip(0);
            DrawText.drawText("No Data", g1, 5, DrawText.getHeight() + 6);
            return;
        }
        this.iHeaderBarHeight = this.iHeaderText != null ? DrawText.getHeight() + 6 : 0;
        g1.translate(iClipWidth - this.iTotalAreaWidth >> 1, (iClipHeight - this.iTotalAreaHeight >> 1) + this.iHeaderBarHeight);
        g1.translate(-this.iHorrizontalScroll, -this.iVerticleScroll);
        int iCellsYCods = 0;
        for (int iRowCount = 0; iRowCount < this.iMaxNumberOfRows; ++iRowCount) {
            int iCellsXCods = 0;
            g1.setColor(this.iBorderColor);
            g1.fillRect(0, iCellsYCods, this.iXCoordinate, this.iBorderDepth);
            iCellsYCods += this.iBorderDepth;
            for (int iColCount = 0; iColCount < this.iMaxNumberOfColumns; ++iColCount) {
                boolean bVisible;
                g1.setColor(this.iBorderColor);
                g1.drawRect(iCellsXCods, iCellsYCods, this.iCellsWidth[iColCount], this.iCellsHeight[iRowCount]);
                g1.setColor(iRowCount == this.iRow ? 9613776 : this.iBgColor);
                g1.fillRect(this.iBorderDepth + iCellsXCods, iCellsYCods, this.iCellsWidth[iColCount], this.iCellsHeight[iRowCount]);
                iCellsXCods += this.iBorderDepth;
                int len = this.iDisplayableData[iRowCount][iColCount].length;
                for (int DataCount = 0; DataCount < len; ++DataCount) {
                    int tmpXPosition = this.iColumnOrientation[iColCount] == 0 ? this.iDataHorrizonatlOffsetInCell + iCellsXCods : (this.iColumnOrientation[iColCount] == 2 ? this.iDataHorrizonatlOffsetInCell + iCellsXCods + (this.iCellsWidth[iColCount] - DrawText.getWidth(this.iDisplayableData[iRowCount][iColCount][DataCount])) : this.iDataHorrizonatlOffsetInCell + iCellsXCods + (this.iCellsWidth[iColCount] - DrawText.getWidth(this.iDisplayableData[iRowCount][iColCount][DataCount])) / 2);
                    DrawText.setStrip(this.FONT_STYLE);
                    DrawText.drawText(this.iDisplayableData[iRowCount][iColCount][DataCount], g1, tmpXPosition - 1, this.iDataHorrizonatlOffsetInCell + iCellsYCods + DataCount * (DrawText.getHeight() + this.iDataVerticleOffsetInCell), -1, 0, 0, 0, iClipWidth - this.iHorrizontalScroll, iClipHeight + this.iVerticleScroll);
                }
                int iInitialY = (iClipHeight - this.iTotalAreaHeight >> 1) + this.iHeaderBarHeight + iCellsYCods - this.iVerticleScroll;
                boolean bl = bVisible = iInitialY > JPlatformCanvas.TITLE_BAR_HEIGHT && iInitialY + this.iCellsHeight[iRowCount] < JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT;
                if (JPlatformCanvas.getInstance().hasPointerEvents() && bVisible) {
                    ScreenPointerDefinition.setPointer(JPlatformCanvas.getInstance().getTitle(), this.iCellData[iRowCount][iColCount], iCellsXCods, iInitialY, iCellsXCods + this.iCellsWidth[iColCount], iInitialY + this.iCellsHeight[iRowCount]);
                }
                iCellsXCods += this.iCellsWidth[iColCount];
            }
            iCellsYCods += this.iCellsHeight[iRowCount];
        }
        g1.setColor(this.iBorderColor);
        g1.fillRect(0, iCellsYCods, this.iXCoordinate, this.iBorderDepth);
        g1.translate(this.iHorrizontalScroll, this.iVerticleScroll);
        g1.translate(-(iClipWidth - this.iTotalAreaWidth >> 1), -((iClipHeight - this.iTotalAreaHeight >> 1) + this.iHeaderBarHeight));
        g1.setClip(0, 0, iClipWidth, iClipHeight);
        int tmpWidth = 0;
        int tmpXPosition = 0;
        int TopOffset = iClipHeight - this.iTotalAreaHeight;
        if (TopOffset > 0) {
            g1.setColor(0xFFFFFF);
            g1.fillRect(0, 0, iClipWidth, TopOffset - this.iHeaderBarHeight);
        }
        for (int iColCount = 0; iColCount < this.iMaxNumberOfColumns; ++iColCount) {
            if (this.iHeaderText == null) continue;
            g1.setColor(11841962);
            g1.fillRect(tmpWidth, TopOffset >> 1, this.iCellsWidth[iColCount], this.iHeaderBarHeight);
            g1.setColor(0);
            g1.drawRect(tmpWidth, TopOffset >> 1, this.iCellsWidth[iColCount], this.iHeaderBarHeight);
            tmpWidth += this.iCellsWidth[iColCount] + this.iBorderDepth;
            if (this.iHeaderText[iColCount] == null) continue;
            DrawText.setStrip(0);
            DrawText.drawText(this.iHeaderText[iColCount], g1, tmpXPosition + (this.iCellsWidth[iColCount] - DrawText.getWidth(this.iHeaderText[iColCount])) / 2, TopOffset + (this.iHeaderBarHeight - DrawText.getHeight()) >> 1, -1, 0, 0, 0, iClipWidth * 2, iClipHeight * 4);
            tmpXPosition += this.iDataHorrizonatlOffsetInCell + this.iCellsWidth[iColCount];
        }
    }

    public final String getCellData(int iRow, int iCol) {
        return this.iCellData[iRow][iCol];
    }

    public final String getRowData(String strpProfitLoss) {
        String result = "";
        for (int i = 0; i < this.iMaxNumberOfColumns; ++i) {
            result = result + this.iHeaderText[i] + " : " + this.iCellData[this.iRow][i] + "\n\n";
        }
        return result + (strpProfitLoss.startsWith("-") ? "Loss" : "Profit") + " : " + strpProfitLoss;
    }

    public String getHeader(int iCol) {
        return this.iHeaderText[iCol];
    }

    public int getNumberOfRows() {
        return this.iMaxNumberOfRows;
    }

    public int getNumberOfCols() {
        return this.iMaxNumberOfColumns;
    }

    public int getSelectedRow() {
        return this.iRow;
    }

    public void updateCell(String newData, int row, int col) {
        this.iCellData[row][col] = newData;
        this.resetGrid(this.iHeaderText, this.iCellData);
    }

    public void drawOtherInfo(Graphics g, String text, int x, int y, int endx, int orient, int fontType) {
        if (this.iMaxNumberOfRows > 0) {
            DrawText.setStrip(fontType);
            DrawText.drawText(text, g, x, y, endx, orient);
        }
    }

    public void setMainValues(String strpTotalValueOrDesc) {
        if (AppConstants.IsScripByReq) {
            this.strMainHeading = strpTotalValueOrDesc;
            this.strTotalValue = "";
        } else {
            this.strMainHeading = "Net. (P/L)";
            this.strTotalValue = strpTotalValueOrDesc.startsWith("-") ? strpTotalValueOrDesc : "+" + strpTotalValueOrDesc;
        }
    }

    public void resetGrid(String[] ColTitle, String[][] newDataSet) {
        int[] tmpOrient = new int[this.iMaxNumberOfColumns];
        System.arraycopy(this.iColumnOrientation, 0, tmpOrient, 0, this.iColumnOrientation.length);
        this.initializeVariables();
        this.setRowColData(ColTitle, newDataSet);
        for (int col = 0; col < this.iMaxNumberOfColumns; ++col) {
            this.setColumnOrientation(col, tmpOrient[col]);
        }
    }

    public void removeEntireRow(int rowID) {
        if (rowID >= 0 && rowID <= this.iMaxNumberOfRows) {
            String[][] tmpArray = new String[this.iMaxNumberOfRows - 1][this.iMaxNumberOfColumns];
            System.arraycopy(this.iCellData, 0, tmpArray, 0, rowID);
            System.arraycopy(this.iCellData, rowID + 1, tmpArray, rowID, this.iCellData.length - (rowID + 1));
            this.iMaxNumberOfRows = (byte)tmpArray.length;
            this.resetGrid(this.iHeaderText, tmpArray);
        }
    }

    public final void keyEvent(int keyCode) {
        switch (keyCode) {
            case 221: {
                this.reAdjustScrolling(0, -1);
                return;
            }
            case 222: {
                this.reAdjustScrolling(0, 1);
                return;
            }
            case 224: {
                this.reAdjustScrolling(1, 0);
                return;
            }
            case 223: {
                this.reAdjustScrolling(-1, 0);
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keyCode);
            }
        }
    }

    public void pointerPressed(String fsSection, int x, int y) {
        if (fsSection.equals("HEADER")) {
            this.reAdjustScrolling(0, -1);
        } else if (fsSection.equals("FOOTER")) {
            this.reAdjustScrolling(0, 1);
        } else {
            this.isPointerSelected(fsSection);
        }
    }

    public boolean isPointerSelected(String lsSection) {
        for (int rowCount = 0; rowCount < this.iMaxNumberOfRows; ++rowCount) {
            for (int colCount = 0; colCount < this.iMaxNumberOfColumns; ++colCount) {
                if (!lsSection.equals(this.iCellData[rowCount][colCount])) continue;
                this.iRow = (byte)rowCount;
                return true;
            }
        }
        return false;
    }

    private boolean adjustScrolling(int xShift, int yShift) {
        boolean flag = false;
        if (xShift > 0 && this.iCellsXPos[this.iColumn] + this.iCellsWidth[this.iColumn] > this.iHorrizontalScroll + this.iTotalAreaWidth) {
            this.iHorrizontalScroll += 25;
            flag = true;
        } else if (xShift < 0 && this.iCellsXPos[this.iColumn] < this.iHorrizontalScroll) {
            this.iHorrizontalScroll -= 25;
            flag = true;
        }
        if (yShift > 0 && this.iCellsYPos[this.iRow] + this.iCellsHeight[this.iRow] > this.iVerticleScroll + this.iTotalAreaHeight - this.iHeaderBarHeight) {
            this.iVerticleScroll += 25;
            flag = true;
        } else if (yShift < 0 && this.iCellsYPos[this.iRow] < this.iVerticleScroll) {
            this.iVerticleScroll -= 25;
            flag = true;
        }
        if (flag) {
            this.iHorrizontalScroll = Math.max(0, Math.min(this.iHorrizontalScroll, this.iXCoordinate - this.iTotalAreaWidth));
            this.iVerticleScroll = Math.max(0, Math.min(this.iVerticleScroll, this.iYCoordinate - this.iTotalAreaHeight + this.iHeaderBarHeight));
        }
        return flag;
    }

    private void reAdjustScrolling(int xShift, int yShift) {
        if (this.iMaxNumberOfRows <= 0) {
            return;
        }
        if (!this.adjustScrolling(xShift, yShift)) {
            int NewCol = this.iColumn + xShift;
            int NewRow = this.iRow + yShift;
            if (NewCol >= 0 && NewRow >= 0 && NewRow < this.iMaxNumberOfRows && NewCol < this.iMaxNumberOfColumns) {
                this.iColumn = (byte)NewCol;
                this.iRow = (byte)NewRow;
                this.adjustScrolling(xShift, yShift);
            }
        }
    }

    public static String[] formatTextInCells(String unformattedText, char tokenizer, int currentFontStrip, int cellWidth) {
        DrawText.setStrip(currentFontStrip);
        int tmpIndex = 0;
        int IndexOfChar = unformattedText.indexOf(tokenizer);
        Vector<String> vector = new Vector<String>();
        StringBuffer stringbuffer = new StringBuffer();
        String targetString = "";
        while (tmpIndex != -1) {
            int newIndex = tmpIndex != 0 ? tmpIndex + 1 : tmpIndex;
            String s2 = IndexOfChar != -1 ? unformattedText.substring(newIndex, IndexOfChar) : unformattedText.substring(newIndex);
            tmpIndex = IndexOfChar;
            IndexOfChar = unformattedText.indexOf(tokenizer, tmpIndex + 1);
            if (s2.length() == 0) continue;
            if (stringbuffer.length() > 0) {
                stringbuffer.append(tokenizer);
            }
            stringbuffer.append(s2);
            if (DrawText.getWidth(stringbuffer.toString()) > cellWidth) {
                if (targetString.length() > 0) {
                    vector.addElement(targetString);
                }
                stringbuffer.setLength(0);
                stringbuffer.append(s2);
            }
            targetString = stringbuffer.toString();
        }
        if (targetString.length() > 0) {
            vector.addElement(targetString);
        }
        Object[] formattedText = new String[vector.size()];
        vector.copyInto(formattedText);
        vector = null;
        stringbuffer = null;
        targetString = null;
        return formattedText;
    }
}

