/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import java.util.Hashtable;

public class ScreenPointerDefinition {
    private String msSection = null;
    private int miXCordinate = 0;
    private int miYCordinate = 0;
    private int miXXCordinate = 0;
    private int miYYCordinate = 0;
    private static Hashtable moPointer = new Hashtable();

    private ScreenPointerDefinition(String fsSection, int fiXCordinate, int fiYCordinate, int fiXXCordinate, int fiYYCordinate) {
        this.msSection = fsSection;
        this.miXCordinate = fiXCordinate;
        this.miYCordinate = fiYCordinate;
        this.miXXCordinate = fiXXCordinate;
        this.miYYCordinate = fiYYCordinate;
    }

    public String getSectionName() {
        return this.msSection;
    }

    public int getXCordinate() {
        return this.miXCordinate;
    }

    public int getYCordinate() {
        return this.miYCordinate;
    }

    public int getXXCordinate() {
        return this.miXXCordinate;
    }

    public int getYYCordinate() {
        return this.miYYCordinate;
    }

    public static void setPointer(String fsScreen, String fsSection, int fiXCordinate, int fiYCordinate, int fiXXCordinate, int fiYYCordinate) {
        if (!moPointer.containsKey(fsScreen)) {
            ScreenPointerDefinition[] loPointer = new ScreenPointerDefinition[]{new ScreenPointerDefinition(fsSection, fiXCordinate, fiYCordinate, fiXXCordinate, fiYYCordinate)};
            moPointer.put(fsScreen, loPointer);
        } else {
            ScreenPointerDefinition[] loOldPointer = (ScreenPointerDefinition[])moPointer.get(fsScreen);
            boolean lbHasSectionLocked = ScreenPointerDefinition.checkSectionIsLocked(loOldPointer, fsSection);
            if (!lbHasSectionLocked) {
                ScreenPointerDefinition[] loNewPointer = new ScreenPointerDefinition[loOldPointer.length + 1];
                System.arraycopy(loOldPointer, 0, loNewPointer, 0, loOldPointer.length);
                loNewPointer[loNewPointer.length - 1] = new ScreenPointerDefinition(fsSection, fiXCordinate, fiYCordinate, fiXXCordinate, fiYYCordinate);
                moPointer.put(fsScreen, loNewPointer);
            }
        }
    }

    private static boolean checkSectionIsLocked(ScreenPointerDefinition[] foOldPointer, String fsSection) {
        boolean lbHasSectionLocked = false;
        for (int i = 0; i < foOldPointer.length; ++i) {
            if (!fsSection.equals(foOldPointer[i].getSectionName())) continue;
            lbHasSectionLocked = true;
            break;
        }
        return lbHasSectionLocked;
    }

    public String toString() {
        return "Section = " + this.msSection + "\n" + "XCordinate = " + this.miXCordinate + "\n" + "YCordinate = " + this.miYCordinate + "\n" + "XXCordinate = " + this.miXXCordinate + "\n" + "YYCordinate = " + this.miYYCordinate;
    }

    public static String getClickedSection(String fsScreen, int fiXCordinate, int fiYCordinate) {
        String lsSection = null;
        if (moPointer.size() > 0) {
            ScreenPointerDefinition[] loPointer = (ScreenPointerDefinition[])moPointer.get(fsScreen);
            for (int i = 0; i < loPointer.length; ++i) {
                if (fiXCordinate < loPointer[i].getXCordinate() || fiYCordinate < loPointer[i].getYCordinate() || fiXCordinate > loPointer[i].getXXCordinate() || fiYCordinate > loPointer[i].getYYCordinate()) continue;
                lsSection = loPointer[i].getSectionName();
                break;
            }
        }
        return lsSection;
    }

    public static void clearScreenPointer() {
        moPointer.clear();
    }
}

