/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.DrawText;
import javax.microedition.lcdui.Graphics;

public abstract class Component {
    protected int WIDTH;
    protected int HEIGHT;
    protected int screenY = 0;
    protected int screenX = 0;
    protected boolean isVisible = false;
    protected boolean isCompletelyVisible = false;
    private boolean isFocused = false;
    protected boolean focusable = false;
    protected String Label = null;
    protected final int background;
    protected final int focusedBackground;
    protected boolean drawPopUp = false;

    public Component() {
        this.background = -1;
        this.focusedBackground = 0xD5D5AA;
    }

    public int getHeight() {
        return this.HEIGHT;
    }

    public int getWidth() {
        return this.WIDTH;
    }

    public String getLabel() {
        return this.Label;
    }

    public int getLabelHeight() {
        int labelHeight = 0;
        if (this.Label != null && this.Label.length() > 0) {
            labelHeight = DrawText.getHeight();
        }
        return labelHeight;
    }

    public boolean isFocusOwner() {
        return this.isFocused;
    }

    public void requestFocus() {
        if (this.focusable) {
            this.isFocused = true;
        }
    }

    public void releaseFocus() {
        if (this.focusable) {
            this.isFocused = false;
        }
    }

    public void setDimenssion(int width, int height) {
        this.WIDTH = width;
        this.HEIGHT = height;
    }

    protected boolean keyPressed(int keyCode) {
        return false;
    }

    public int getBackground() {
        return this.isFocusOwner() ? 0xD5D5AA : -1;
    }

    public void setLabel(String text) {
        if (text != null) {
            this.Label = text;
        }
    }

    public abstract void drawComponent(Graphics var1);

    protected void paintBackground(Graphics g, int startX, int width, int height) {
        if (this.getBackground() != -1) {
            g.setColor(this.getBackground());
            g.fillRect(startX, this.screenY, width, height);
            g.setColor(0);
            g.drawRect(startX - 1, this.screenY - 1, width + 2, height);
        }
    }

    protected boolean keyReleased(int keyCode) {
        return false;
    }

    protected boolean keyRepeated(int keyCode) {
        return false;
    }

    protected boolean pointerDragged(int x, int y) {
        return false;
    }

    protected boolean pointerPressed(int x, int y) {
        return false;
    }

    protected boolean pointerReleased(int x, int y) {
        return false;
    }

    public void drawListWindow(Graphics g) {
    }

    public void scrolUp() {
    }

    public void scrolDn() {
    }

    public void destructor() {
    }
}

